package de.intarsys.tools.system;

public class SystemTools {

	private final static String osName;
	private final static String osArch;

	private static boolean citrix = false;
	private static boolean windows = false;
	private static boolean linux = false;
	private static boolean mac = false;

	static {
		String tempName = System.getProperty("de.intarsys.platform.os.name");
		String tempArch = System.getProperty("de.intarsys.platform.os.arch",
				"x86");
		if (tempName == null) {
			tempName = System.getProperty("os.name"); //$NON-NLS-1$
			tempArch = System.getProperty("os.arch"); //$NON-NLS-1$
		}
		osName = tempName;
		osArch = tempArch;
		String osNameLowerCase = osName.toLowerCase();
		if (osNameLowerCase.startsWith("win")) { //$NON-NLS-1$
			windows = true;
		} else if (osNameLowerCase.startsWith("linux")) { //$NON-NLS-1$
			linux = true;
		} else if (osNameLowerCase.startsWith("mac")) { //$NON-NLS-1$
			mac = true;
		}
		citrix = Boolean.getBoolean("de.intarsys.platform.citrix");
	}

	public static String getOSArch() {
		return osArch;
	}

	public static String getOSName() {
		return osName;
	}

	public static boolean isCitrix() {
		return citrix;
	}

	public static boolean isLinux() {
		return linux;
	}

	public static boolean isMac() {
		return mac;
	}

	public static boolean isWindows() {
		return windows;
	}

	private SystemTools() {
		// tools class
	}
}
