/*
 * Copyright (c) 2007, intarsys consulting GmbH
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * - Neither the name of intarsys nor the names of its contributors may be used
 *   to endorse or promote products derived from this software without specific
 *   prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package de.intarsys.tools.event;


/**
 * 
 */
public class GenericEventFacade extends AbstractEventFacade {
	/**
	 * 
	 */
	public GenericEventFacade(GenericEvent event) {
		super(event);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.intarsys.tools.event.IEvent#consume()
	 */
	public void consume() {
		((GenericEvent) object).consume();
	}

	public Object getArgs() {
		return ((GenericEvent) object).getArgs();
	}

	public EventType getEventType() {
		return ((GenericEvent) object).getEventType();
	}

	public String getName() {
		return ((GenericEvent) object).getName();
	}

	public boolean getRc() {
		return ((GenericEvent) object).getRc();
	}

	public Object getSource() {
		return createFacade(((GenericEvent) object).getSource());
	}

	public Object getTarget() {
		return createFacade(((GenericEvent) object).getTarget());
	}

	@Override
	public String getType() {
		return ((GenericEvent) object).getEventType().getName();
	}

	public Object getValue() {
		return createFacade(((GenericEvent) object).getValue());
	}

	@Override
	public boolean getVeto() {
		return ((GenericEvent) object).isVetoed();
	}

	public boolean isConsumed() {
		return ((GenericEvent) object).isConsumed();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.intarsys.tools.event.IEvent#isVetoed()
	 */
	public boolean isVetoed() {
		return ((GenericEvent) object).isVetoed();
	}

	public void setRc(boolean value) {
		((GenericEvent) object).setRc(value);
	}

	public void setTarget(Object target) {
		((GenericEvent) object).setTarget(target);
	}

	public void setValue(Object value) {
		((GenericEvent) object).setValue(value);
	}

	@Override
	public void setVeto(boolean value) {
		((GenericEvent) object).setVeto(value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.intarsys.tools.event.IEvent#veto()
	 */
	public void veto() {
		((GenericEvent) object).veto();
	}
}
