package org.pietschy.command.interceptor;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * DefaultGlassPaneHander is an implementation of {@link org.pietschy.command.interceptor.GlassPaneHandler} that simply
 * displays the wait cursor and beeps when ever the user clicks.
 */
public class
CustomComponentGlassPaneHandler
implements GlassPaneHandler
{
   private Component glasspane;
   private Component originalGlassPane;


   public CustomComponentGlassPaneHandler(Component glasspane)
   {
      this.glasspane = glasspane;
   }


   public void
   activateGlassPane(RootPaneContainer rootPaneContainer)
   {

      originalGlassPane = rootPaneContainer.getGlassPane();
      rootPaneContainer.setGlassPane(glasspane);
   }

   public void
   deactivateGlassPane(RootPaneContainer rootPaneContainer)
   {
      rootPaneContainer.setGlassPane(originalGlassPane);
   }
}
