// $Id: BeepCommand.java,v 1.6 2004/12/12 05:29:27 pietschy Exp $
// Copyright (c) 2000-2001 The Forge Group. All rights reserved.
/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: BeepCommand.java,v 1.6 2004/12/12 05:29:27 pietschy Exp $
 */
package org.pietschy.command.demo;

import org.pietschy.command.ActionCommand;

import java.awt.*;
import java.util.Map;

public class
BeepCommand
extends ActionCommand
{
   static final String _ID_ = "$Id: BeepCommand.java,v 1.6 2004/12/12 05:29:27 pietschy Exp $";

   public static final String BEEP_COUNT = "beep-count";


   public BeepCommand(String commandId)
   {
      super(commandId);
      export();
   }

   /**
    * This method is called whenever the Command is executed.  All subclasses must
    * override this method to implement their specific behaviour.<p>
    * This method should never be called directly to invoke a comand.  All
    * command invocation must be performed using the {@link #execute()} and
    * {@link #execute(Map)} methods.
    */
   protected void handleExecute()
   {
      int beepCount = 1;
      Object hint = getHint(BEEP_COUNT);
      if (hint instanceof Integer)
         beepCount = ((Integer) hint).intValue();

      for (int i = 0; i < beepCount; i++)
         Toolkit.getDefaultToolkit().beep();
   }
}
