/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: BeanIcon.java,v 1.3 2005/09/18 00:37:19 pietschy Exp $
 */
package org.pietschy.command.demo;

import javax.swing.*;
import java.awt.*;

/**
 * Created by IntelliJ IDEA.
 * User: andrewp
 * Date: 12/04/2004
 * Time: 12:33:37
 * To change this template use Options | File Templates.
 */
public class
BeanIcon
implements Icon
{
   private Color color;

   public BeanIcon()
   {
      this(Color.BLUE);
   }

   private BeanIcon(Color color)
   {
      this.color = color;
   }

   public void paintIcon(Component c, Graphics g, int x, int y)
   {
      g.setColor(color);
      g.fillRoundRect(x, y, 15 , 15, 4 , 4);
   }

   public int getIconWidth()
   {
      return 16;
   }

   public int getIconHeight()
   {
      return 16;
   }

   public static BeanIcon redIcon()
   {
      return new BeanIcon(Color.RED);
   }

   public static BeanIcon parametisedIcon(String red, String green, String blue)
   {
      return new BeanIcon(new Color(Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue)));
   }
}
