/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: RemoveVisitor.java,v 1.6 2005/06/15 23:43:01 pietschy Exp $
 */

package org.pietschy.command;


/**
 * This command will traverse a group heirarchy and remove the specified command.
 *
 * @author andrewp
 * @version $Revision: 1.6 $
 */
public class RemoveVisitor
extends AbstractVisitor
{

   private Command removeCommand;

   /**
    * Constructs an new RemoveVisitor that will deeply traverse the group and all its child groups.
    *
    * @param removeCommand the command to removed.
    */
   public RemoveVisitor(Command removeCommand)
   {
      this(removeCommand, DEEP);
   }

   /**
    * Constructs an new RemoveVisitor that will traverse the group according the to visit mode.
    *
    * @param removeCommand the command to removed.
    * @param mode the mode in which to visit the parent group, either {@link AbstractVisitor#DEEP} or {@link AbstractVisitor#SHALLOW}.
    */
   public RemoveVisitor(Command removeCommand, VisitMode mode)
   {
      super(mode);
      this.removeCommand = removeCommand;
   }

   public void
   visit(ActionCommand command)
   {
   }

   public void
   visit(CommandGroup group)
   {
      if (group.contains(removeCommand))
         group.remove(removeCommand);

      conditionallyVisitChildren(group);
   }


}
