/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: HoverListener.java,v 1.2 2004/12/12 05:29:23 pietschy Exp $
 */

package org.pietschy.command;

import java.util.EventListener;

/**
 * This interface provides notification of when the mouse have hovered over a Command.
 * Listeners need to register will the {@link CommandManager} using
 * {@link CommandManager#addHoverListener} to recieve events.
 * @see HoverEvent
 * @see CommandManager#addHoverListener
 */
public interface
HoverListener
extends EventListener
{
   /**
    * Notification that the mouse has moved over a command.
    * @param e a {@link HoverEvent} specifying the details.
    */
   public void hoverStarted(HoverEvent e);

   /**
    * Notification that the mouse has moved off a command.
    * @param e a {@link HoverEvent} specifying the details.
    */
   public void hoverEnded(HoverEvent e);
}
