/*******************************************************************************************************************************************
 cvboxlayout.c
*******************************************************************************************************************************************/

#include "cvboxlayout.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CVBoxLayout);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CVBoxLayout::CVBoxLayout (CContainer *inOwner, const CWidgetListener *inListener)
	    :CBoxLayout  (inOwner, inListener)
{
	// instanciation request
	if (inOwner != NULL) CWidget::CreateWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CVBoxLayout::~CVBoxLayout ()
{ 
	// deletion coherence request
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// widget instanciation
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CVBoxLayout::PerformWidgetInstanciate ()
{
	// ok
	return ::gtk_vbox_new (m_Homogeneous, m_Spacing);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// drop index calculation
//-----------------------------------------------------------------------------------------------------------------------------------------
SInt16 CVBoxLayout::GetDropIndexAtPoint (const TPoint &inRelativePoint, const CControl *inCandidate) const
{
	// first, get the control at the given coordinates
	CControl *inReference = GetControlAtPoint (inRelativePoint);

	// check the pointer and the class type
	if (inReference == NULL || !inReference -> ClassIs (__metaclass(CWidget))) return -1;

	// get the referenced widget in owner index
	SInt16 inIndex (CContainer::GetGtkInOwnerIndex (this, static_cast <CWidget *> (inReference)));

	// check the index, if not found defaults to an append specification at the end of the current owned children list
	if (inIndex < 0) return inIndex;
	
	// get the referenced widget bounds
	TBounds inBounds (inReference -> GetBounds());

	// let's check if the candidate control and the referenced one are owned by the same control i.e. if the request would map
	// a dnd in owner move only, if not and pointing to the lower zone of the referenced widget, convert to an append specification
	if (!inReference -> HasSibling (inCandidate))

		// analyse the point place
		if (inRelativePoint.y > (inBounds.y + inBounds.h/2)) inIndex++;

	// ok
	return inIndex;
}




