/*******************************************************************************************************************************************
 cpaned.c
*******************************************************************************************************************************************/

#include "cpaned.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_GENERIC_METACLASS (CPaned);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CPaned::CPaned	(CContainer *inOwner, const CWidgetListener *inListener)
       :CLayout	(inOwner, inListener)
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CPaned::~CPaned ()
{ 
	// should not be called at this level; anyway, try to avoid the worst in case of...
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget initialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CPaned::PerformWidgetInitialize ()
{
	// show our job
	Show ();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// container child add
//-----------------------------------------------------------------------------------------------------------------------------------------
void CPaned::PerformContainerAdd (CWidget *inChild)
{
	// check incoming pointer...
	if (inChild == NULL || inChild -> GetGtkWidget() == NULL) return;
	
	// check this instance gtk pointer
	GtkWidget *inGtkWidget (GetGtkWidget()); if (inGtkWidget == NULL) return;

	// get the specified child in this owner index
	SInt16 inIndex (CContainer::GetGtkInOwnerIndex (this, inChild));

	// perform the pack
	switch (inIndex)
	{
		// insert
		case 0 : 
		{
			// is there any child yet ? move it to the right or bottom paned if so
			if (::gtk_paned_get_child1 (GTK_PANED(inGtkWidget)) != NULL)
				if (CWidget::GetGtkolWidget(::gtk_paned_get_child1 (GTK_PANED(inGtkWidget))) != NULL)
					if (!(CWidget::GetGtkolWidget(::gtk_paned_get_child1 (GTK_PANED(inGtkWidget)))) -> 
						SetOwner (this, 1))
						return;

			// left or top pack specification
			::gtk_paned_add1 (GTK_PANED(inGtkWidget), inChild->GetGtkWidget());
		}
		break;

		// append
		default :
		{
			// is there any child yet ? move it to the left or top paned if so
			if (::gtk_paned_get_child2 (GTK_PANED(inGtkWidget)) != NULL)
				if (CWidget::GetGtkolWidget(::gtk_paned_get_child2 (GTK_PANED(inGtkWidget))) != NULL)
					if (!(CWidget::GetGtkolWidget(::gtk_paned_get_child2 (GTK_PANED(inGtkWidget)))) -> 
						SetOwner (this, 0))
						return;

			// right or bottom pack specification
			::gtk_paned_add2 (GTK_PANED(inGtkWidget), inChild->GetGtkWidget());
		}
		break;
	}
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// container child remove
//-----------------------------------------------------------------------------------------------------------------------------------------
void CPaned::PerformContainerRemove (CWidget *inChild)
{
	// generic call...
	CLayout::PerformContainerRemove (inChild);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// max children handling
//-----------------------------------------------------------------------------------------------------------------------------------------
SInt16 CPaned::GetGtkChildrenNumberLeft () const
{
	// the paned owns 2 widgets max
	return 2 - GetGtkChildren().GetLength();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// position writer
//-----------------------------------------------------------------------------------------------------------------------------------------
void CPaned::SetPosition (const SInt32 inPosition)
{
	// get the gtkol gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// property affectation
	::gtk_paned_set_position (GTK_PANED(inGtkWidget), inPosition);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// position reader
//-----------------------------------------------------------------------------------------------------------------------------------------
SInt32 CPaned::GetPosition () const
{
	// get the gtkol gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// property reader
	return inGtkWidget != NULL ? ::gtk_paned_get_position (GTK_PANED(inGtkWidget)) : -1;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// xml serialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CPaned::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	// generic call first
	CLayout::Serialize (ioXMLElementNode, inMode);

	// request analyse
	switch (inMode)
	{
		// xml dump
		case XML_WRITE :
		{
			// instanciate a new xml element
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_PANED_ELEMENT);

			// add the cpaned attributes
			newXMLElement -> AddAttribute (XML_PANED_ATTR_POSITION, CString(GetPosition()));

			// modify the io xml element node
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();
		}
		break;

		// xml read
		case XML_READ :
		{
			// get the child node this serialization process is interested in
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_PANED_ELEMENT);

			// check we got an expected cpaned node
			if (inXMLNode == NULL)
				throw new CException (CString("CPaned::Serialize, specified xml node is not a \"") + 
							      XML_PANED_ELEMENT + CString("\" element one."), __exception(XMLPARSE));

			// modify the in/out element node pointer so that the serialization process will continue under the cpaned node
			ioXMLElementNode = inXMLNode;

			// get the position attribute and set it
			SetPosition (::xml_node_get_attribute (inXMLNode, XML_PANED_ATTR_POSITION).GetValue().ToLong());
		}
		break;
	}
}

