/******************************************************************************************************************************************
 caboutdialog.c
******************************************************************************************************************************************/

#include "caboutdialog.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CAboutDialog);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CAboutDialog::CAboutDialog (CForm *inOwner, const CString &inCaption, const bool inModal, const CDialogListener *inListener)
	     :CDialog	   (NULL, inCaption, _DBNone_, inModal, inListener),
	      m_Pixbuf	   (NULL)
{
	// request the gtk widget instanciation process
	if (inOwner != NULL) SetOwner (inOwner);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CAboutDialog::~CAboutDialog ()
{
	// delete the pixbuf if any
	if (m_Pixbuf != NULL) delete m_Pixbuf;

	// gtk widget deletion coherence requested
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget instanciation
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CAboutDialog::PerformWidgetInstanciate ()
{
	// ok, very simple...
	return ::gtk_about_dialog_new();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget initialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CAboutDialog::PerformWidgetInitialize ()
{
	// generic call, no more to initialize
	CDialog::PerformWidgetInitialize();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// xml serialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CAboutDialog::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	// generic call
	CDialog::Serialize (ioXMLElementNode, inMode);

	// serialization request analyse
	switch (inMode)
	{
		// xml dump
		case XML_WRITE :
		{
		}
		break;
	
		// xml load
		case XML_READ :
		{
		}
		break;
	}
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// name  
//-----------------------------------------------------------------------------------------------------------------------------------------
void CAboutDialog::SetName (const CString &inName)
{
	// retrieve the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointer
	if (inGtkWidget == NULL) return;

	// set it
	::gtk_about_dialog_set_name (GTK_ABOUT_DIALOG(inGtkWidget), inName.Get());
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// name  
//-----------------------------------------------------------------------------------------------------------------------------------------
CString CAboutDialog::GetName () const
{
	// ok
	return GetGtkWidget() ? CString(::gtk_about_dialog_get_name (GTK_ABOUT_DIALOG(GetGtkWidget()))) : CString();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// version 
//-----------------------------------------------------------------------------------------------------------------------------------------
void CAboutDialog::SetVersion (const CString &inVersion)
{
	// retrieve the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointer
	if (inGtkWidget == NULL) return;

	// set it
	::gtk_about_dialog_set_version (GTK_ABOUT_DIALOG(inGtkWidget), inVersion.Get());
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// version 
//-----------------------------------------------------------------------------------------------------------------------------------------
CString CAboutDialog::GetVersion () const
{
	// ok
	return GetGtkWidget() ? CString(::gtk_about_dialog_get_version (GTK_ABOUT_DIALOG(GetGtkWidget()))) : CString();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// copyright
//-----------------------------------------------------------------------------------------------------------------------------------------
void CAboutDialog::SetCopyright (const CString &inCopyRight)
{
	// retrieve the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointer
	if (inGtkWidget == NULL) return;

	// set it
	::gtk_about_dialog_set_copyright (GTK_ABOUT_DIALOG(inGtkWidget), inCopyRight.Get());
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// copyright
//-----------------------------------------------------------------------------------------------------------------------------------------
CString CAboutDialog::GetCopyright () const
{
	// ok
	return GetGtkWidget() ? CString(::gtk_about_dialog_get_copyright (GTK_ABOUT_DIALOG(GetGtkWidget()))) : CString();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// license 
//-----------------------------------------------------------------------------------------------------------------------------------------
void CAboutDialog::SetLicense (const CString &inLicense)
{
	// retrieve the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointer
	if (inGtkWidget == NULL) return;

	// set it
	::gtk_about_dialog_set_license (GTK_ABOUT_DIALOG(inGtkWidget), inLicense.Get());
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// license 
//-----------------------------------------------------------------------------------------------------------------------------------------
CString CAboutDialog::GetLicense () const
{
	// ok
	return GetGtkWidget() ? CString(::gtk_about_dialog_get_license (GTK_ABOUT_DIALOG(GetGtkWidget()))) : CString();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// comments
//-----------------------------------------------------------------------------------------------------------------------------------------
void CAboutDialog::SetComments (const CString &inComments)
{
	// retrieve the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointer
	if (inGtkWidget == NULL) return;

	// set it
	::gtk_about_dialog_set_comments (GTK_ABOUT_DIALOG(inGtkWidget), inComments.Get());
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// comments
//-----------------------------------------------------------------------------------------------------------------------------------------
CString CAboutDialog::GetComments () const
{
	// ok
	return GetGtkWidget() ? CString(::gtk_about_dialog_get_comments (GTK_ABOUT_DIALOG(GetGtkWidget()))) : CString();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// set website "http://"
//-----------------------------------------------------------------------------------------------------------------------------------------
void CAboutDialog::SetWebSite (const CString &inLabel, const CString &inURL)
{
	// retrieve the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointer
	if (inGtkWidget == NULL) return;

	// set it
	::gtk_about_dialog_set_website_label (GTK_ABOUT_DIALOG(inGtkWidget), inLabel.Get());
	::gtk_about_dialog_set_website (GTK_ABOUT_DIALOG(inGtkWidget), inURL.Get());
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// website "http://"
//-----------------------------------------------------------------------------------------------------------------------------------------
CString CAboutDialog::GetWebSiteLabel () const
{
	// ok
	return GetGtkWidget() ? CString(::gtk_about_dialog_get_website_label (GTK_ABOUT_DIALOG(GetGtkWidget()))) : CString();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// website "http://"
//-----------------------------------------------------------------------------------------------------------------------------------------
CString CAboutDialog::GetWebSiteURL () const
{
	// ok
	return GetGtkWidget() ? CString(::gtk_about_dialog_get_website (GTK_ABOUT_DIALOG(GetGtkWidget()))) : CString();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// authors
//-----------------------------------------------------------------------------------------------------------------------------------------
void CAboutDialog::SetAuthors (const CStrings &inAuthors)
{
	// retrieve the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointer
	if (inGtkWidget == NULL) return;

	// outbuffer
	gchar **outAuthors = new gchar * [inAuthors.GetLength()+1]; outAuthors[inAuthors.GetLength()] = NULL;
	for (size_t i=inAuthors.GetLength(), j=0; i>0; i--, j++) outAuthors[j] = ::g_strdup (inAuthors[j]->Get());

	// set it
	::gtk_about_dialog_set_authors (GTK_ABOUT_DIALOG(inGtkWidget), (const gchar**)outAuthors);

	// delete the buffer
	for (size_t i=inAuthors.GetLength(), j=0; i>0; i--, j++) delete [] outAuthors[j];
	delete [] outAuthors;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// authors
//-----------------------------------------------------------------------------------------------------------------------------------------
CStrings CAboutDialog::GetAuthors () const
{
	// output buffer
	CStrings outAuthors;

	// retrieve the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointer
	if (inGtkWidget == NULL) return outAuthors;

	// retrieve the buffer
	const gchar* const *inAuthors = ::gtk_about_dialog_get_authors (GTK_ABOUT_DIALOG(inGtkWidget));

	// set the output buffer
	size_t n=0; while (inAuthors[n]) outAuthors += CString(inAuthors[n++]);

	// ok
	return outAuthors;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// artits
//-----------------------------------------------------------------------------------------------------------------------------------------
void CAboutDialog::SetArtits (const CStrings &inArtits)
{
	// retrieve the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointer
	if (inGtkWidget == NULL) return;

	// outbuffer
	gchar **outArtits = new gchar * [inArtits.GetLength()+1]; outArtits[inArtits.GetLength()] = NULL;
	for (size_t i=inArtits.GetLength(), j=0; i>0; i--, j++) outArtits[j] = ::g_strdup (inArtits[j]->Get());

	// set it
	::gtk_about_dialog_set_artists (GTK_ABOUT_DIALOG(inGtkWidget), (const gchar**)outArtits);

	// delete the buffer
	for (size_t i=inArtits.GetLength(), j=0; i>0; i--, j++) delete [] outArtits[j];
	delete [] outArtits;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// artits
//-----------------------------------------------------------------------------------------------------------------------------------------
CStrings CAboutDialog::GetArtits () const
{
	// output buffer
	CStrings outArtits;

	// retrieve the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointer
	if (inGtkWidget == NULL) return outArtits;

	// retrieve the buffer
	const gchar* const *inArtits = ::gtk_about_dialog_get_artists (GTK_ABOUT_DIALOG(inGtkWidget));

	// set the output buffer
	size_t n=0; while (inArtits[n]) outArtits += CString(inArtits[n++]);

	// ok
	return outArtits;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// documenters
//-----------------------------------------------------------------------------------------------------------------------------------------
void CAboutDialog::SetDocumenters (const CStrings &inDocumenters)
{
	// retrieve the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointer
	if (inGtkWidget == NULL) return;

	// outbuffer
	gchar **outDocumenters = new gchar * [inDocumenters.GetLength()+1]; outDocumenters[inDocumenters.GetLength()] = NULL;
	for (size_t i=inDocumenters.GetLength(), j=0; i>0; i--, j++) outDocumenters[j] = ::g_strdup (inDocumenters[j]->Get());

	// set it
	::gtk_about_dialog_set_documenters (GTK_ABOUT_DIALOG(inGtkWidget), (const gchar**)outDocumenters);

	// delete the buffer
	for (size_t i=inDocumenters.GetLength(), j=0; i>0; i--, j++) delete [] outDocumenters[j];
	delete [] outDocumenters;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// documenters
//-----------------------------------------------------------------------------------------------------------------------------------------
CStrings CAboutDialog::GetDocumenters () const
{
	// output buffer
	CStrings outDocumenters;

	// retrieve the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointer
	if (inGtkWidget == NULL) return outDocumenters;

	// retrieve the buffer
	const gchar* const *inDocumenters = ::gtk_about_dialog_get_documenters (GTK_ABOUT_DIALOG(inGtkWidget));

	// set the output buffer
	size_t n=0; while (inDocumenters[n]) outDocumenters += CString(inDocumenters[n++]);

	// ok
	return outDocumenters;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// logo
//-----------------------------------------------------------------------------------------------------------------------------------------
void CAboutDialog::SetLogo (const CPixbuf *inPixbuf)
{
	// keep pointer
	if (m_Pixbuf != NULL) delete m_Pixbuf; m_Pixbuf = const_cast <CPixbuf *> (inPixbuf);

	// retrieve the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointer
	if (inGtkWidget == NULL) return;

	// set it
	::gtk_about_dialog_set_logo (GTK_ABOUT_DIALOG(inGtkWidget), m_Pixbuf->GetPixbuf());
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// logo
//-----------------------------------------------------------------------------------------------------------------------------------------
const CPixbuf * CAboutDialog::GetLogo () const
{
	// ok
	return m_Pixbuf;
}






