%define prefix /usr
%define INSTDIR %{prefix}/lib
%define INCLUDEDIR %{prefix}/include

Summary: GTK c++ Object Layer
Name: libgtkol
Version: 1.4
Release: 2fc6
Source: %{name}-%{version}.tar.gz
BuildRoot: /tmp/%{name}-%{version}
Group: Applications/Base
License: GPL

BuildRequires: gcc >= 4.0.0
BuildRequires: pkgconfig
BuildRequires: glib2-devel >= 2.10
BuildRequires: gtk2-devel >= 2.6
BuildRequires: libxml2-devel
BuildRequires: libgenerics-devel >= 1.2

Requires: gtk+ >= 1.2
Requires: glib2 >= 2.10
Requires: libxml2
Requires: libgenerics >= 1.2

%description
	libgtkol is GTK c++ Object Layer based on the libgenerics abstract services and the gtk engine. It offers the developpers 
	a complete intuitive object API without restricting access to the gtk functionalities. 

%package devel

Summary: GTK C++ Object Layer
License: GPL
Group: Applications/Base

Requires: %{name} = %{version}
Requires: libgenerics-devel >= 1.2
Requires: gtk2-devel >= 2.8
Requires: glib2-devel >= 2.10

%description devel
	The devel package of libgtkol. libgtkol is GTK c++ Object Layer based on the libgenerics abstract services and the gtk engine. 
	It offers the developpers a complete intuitive object API without restricting access to the gtk functionalities. 

%prep

%setup -q

%build
	make all

%install

	mkdir -p %{buildroot}/%{INSTDIR}/%{name}-%{version}/
	mkdir -p %{buildroot}/%{INCLUDEDIR}/%{name}-%{version}/
	mkdir -p %{buildroot}/%{INCLUDEDIR}/%{name}-%{version}/samples

	cp -r include/* %{buildroot}/%{INCLUDEDIR}/%{name}-%{version}/
	cp -r samples/* %{buildroot}/%{INCLUDEDIR}/%{name}-%{version}/samples/

	cp %{name}-%{version}.so %{buildroot}/%{INSTDIR}
	cp %{name}-%{version}.a  %{buildroot}/%{INSTDIR}

	mkdir -p %{buildroot}/usr/lib/pkgconfig/
	cat %{name}-%{version}.pc.in | sed -e 's:prefix=/usr/local:prefix=%{prefix}:g' > %{buildroot}/usr/lib/pkgconfig/%{name}-%{version}.pc

#	mkdir -p %{buildroot}/usr/share/gtk-doc/html/%{name}-%{version}
#	cp -r doc/* %{buildroot}/usr/share/gtk-doc/html/%{name}-%{version}/

%post
	ldconfig

%postun
	ldconfig

%clean
	rm -rf %{buildroot}

%files
	%{INSTDIR}/%{name}-%{version}.so
	%{INSTDIR}/%{name}-%{version}.a

%files devel
	%{INCLUDEDIR}/%{name}-%{version}/
	/usr/lib/pkgconfig/%{name}-%{version}.pc
#	/usr/share/gtk-doc/html/%{name}-%{version}/

%changelog
	* Sun Nov 12 2006 Jrmie Bernard <gremimail@gmail.com>
	- tree view item simple set cursor / edition add on
	* Wed Oct 20 2006 Jrmie Bernard <gremimail@gmail.com> - 1.4 -
	- thread support add on
	* Sat Oct 14 2006 Jrmie Bernard <gremimail@gmail.com>
	- treeview item potential seg fault on null owner affectation patch
	- treeview rules hint, headers visible and titles add on
	* Sun Sep 17 2006 Jrmie Bernard <gremimail@gmail.com>
	- color selection button addon, font selection button addon
	* Wed Jul 05 2006 Jrmie Bernard <gremimail@gmail.com>
	- component spine level destructor null node value potential seg fault resolution
	- tool button to menu item click event redirection option implementation
	- item field value pack abstraction : multiple field values per tree view column handling
	- gtk expander binding add on
	- gtk icon view binding add on
	- file chooser dialog full gtk action types handling
	* Thu Jul 05 2006 Jrmie Bernard <gremimail@gmail.com>
	- generics evolution, virtual AssignListener removal, virtual ListenerMustBe replacement
	* Tue Jun 27 2006 Jrmie Bernard <gremimail@gmail.com>
	- CItemFieldValue listener automatic serialization removed, xml dump lighter
	* Mon Jun 19 2006 Jrmie Bernard <gremimail@gmail.com>
	- added part of the global html reference manual
	* Mon May 29 2006 Jrmie Bernard <gremimail@gmail.com>
	- initial package version 1.2
