/*******************************************************************************************************************************************
 cvseparator.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl			 |
	        |--CWidget			 |--CWidgetListener
		   |--CSeparator
		      |--CVSeparator

*******************************************************************************************************************************************/

#ifndef __CVSEPARATOR_H__
#define __CVSEPARATOR_H__

#include "cseparator.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// CVSeparator class
//------------------------------------------------------------------------------------------------------------------------------------------
class CVSeparator : public CSeparator
{
	// instanciation section
	public :

		CVSeparator			(CContainer *inOwner=NULL, const CWidgetListener *inListener=NULL);
		virtual ~CVSeparator		();

	// widget gtkol requests protected handling
	protected :

		// separator widget instanciation
		virtual GtkWidget *		PerformWidgetInstanciate	();

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('vpar', CVSeparator, CSeparator);


#endif
