/*******************************************************************************************************************************************
 cnotebook.h
 
 CClass						CClass
 |--CSerialized					|--CSerialized
    |--CMetaModule				   |--CMetaModule
       |--CObject				      |--CObjectListener
          |--CComponent			      	      	 |
	     |--CControl			      	 |
	        |--CWidget			      	 |--CWidgetListener
		   |--CContainer			    |
		      |--CNoteBook			    |--CNoteBookListener

*******************************************************************************************************************************************/

#ifndef __CNOTEBOOK_H__
#define __CNOTEBOOK_H__

#include "ccontainer.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// cnotebook xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cnotebook current-page="UInt16" show-tabs="bool" show-border="true" tab-position="top|left|bottom|right" tab-scrollable="bool">
//   <cnotebook-tabs>
//     [<tab-caption>string</tab-caption>]
//   </cnotebook-tabs>
//   ...
// </cnotebook>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_NOTEBOOK_ELEMENT			("cnotebook");
static CString XML_NOTEBOOK_ELEMENT_TABS		("cnotebook-tabs");
static CString XML_NOTEBOOK_ELEMENT_TAB_CAPTION		("tab-caption");
static CString XML_NOTEBOOK_ATTR_SHOW_TABS		("show-tabs");
static CString XML_NOTEBOOK_ATTR_SHOW_BORDER		("show-border");
static CString XML_NOTEBOOK_ATTR_TAB_POSITION		("tab-position");
static CString XML_NOTEBOOK_ATTR_TAB_SCROLLABLE		("tab-scrollable");
static CString XML_NOTEBOOK_ATTR_CURRENT_PAGE		("current-page");

//------------------------------------------------------------------------------------------------------------------------------------------
// CNoteBookListener class
//------------------------------------------------------------------------------------------------------------------------------------------
class CNoteBookListener : public CWidgetListener
{
	// instanciation section
	public :

		CNoteBookListener		();
		virtual ~CNoteBookListener	() =0;

	// listening specifics
	public :

		// called on inSender notebook when the specified tab index containing the inChild child has been selected
		virtual void			OnSwitch			(CObject *inSender, CObject *inChild, 
										 const UInt16 inIndex)				{ }

		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('_ntk', CNoteBookListener, CWidgetListener);

//------------------------------------------------------------------------------------------------------------------------------------------
// CNoteBook class
//------------------------------------------------------------------------------------------------------------------------------------------
class CNoteBook : public CContainer
{
	// instanciation section
	public :

		CNoteBook			(CContainer *inOwner=NULL, const CNoteBookListener *inListener=NULL);
		virtual ~CNoteBook		();

	// protected cwidget requests handling
	protected :

		// gtk widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// protected ccontainer requests handling
	protected :

		// gtk child widget addon removal
		virtual void			PerformContainerAdd		(CWidget *inChild);
		virtual void			PerformContainerRemove		(CWidget *inChild);

	// cobject redefinition
	protected :

		// listener affectation, must be derived from CNoteBookListener
		virtual const CMetaClass *	ListenerMustBe			() const;

	// ccomponent redefinition
	public :

		// expected owner type : CContainer
		virtual CMetaClasses 		OwnerMustBe			() const;

	// ccontainer redefinition
	public :

		// return -1 for unlimited handling
		virtual SInt16			GetGtkChildrenNumberLeft	() const;

	// notebook specifics
	public :

		// tab show / hide
		virtual void			SetShowTabs			(const Bool);
		Bool				GetShowTabs			() const;

		// show border (effective only when the tabs are not shown)
		virtual void			SetShowBorder			(const Bool);
		Bool				GetShowBorder			() const;

		// tab label affectation for given child or tab index (overwrittes default "Page n")
		virtual void			SetTabCaption			(const CString &, const CWidget *);
		virtual void			SetTabCaption			(const CString &, const UInt16);
		virtual CString			GetTabCaption			(const CWidget *) const;
		virtual CString			GetTabCaption			(const UInt16) const;

		// set the tab edje position
		virtual void			SetTabPosition			(const GtkPositionType);
		GtkPositionType			GetTabPosition			() const;

		// set wether the tabs would have a scroll if there is too much tabs to fit in one line
		virtual void			SetTabScrollable		(const Bool);
		Bool				GetTabScrollable		() const;

		// set / get the current page (-1 for the affectation to be the last one)
		virtual void			SetCurrentPage			(const SInt16);
		SInt16				GetCurrentPage			() const;

	// cserialized redefinition
	public :

		// cnotebook serialization
		virtual void			Serialize			(CXMLElementNode *&, const int) THROWABLE;

	// protected section
	protected :

		// signal connection
		static void			OnSwitchPage			(GtkNotebook *, GtkNotebookPage *, guint, gpointer);

		// metaclass association section
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('ntbk', CNoteBook, CContainer);

#endif
