/*******************************************************************************************************************************************
 cfontbutton.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl		         |
	        |--CWidget		         |--CWidgetListener
		   |--CContainer	   	    |
		      |--CButton		    |--CButtonListener
			 |--CFontButton		       |--CFontButtonListener

 A button to launch a font selection dialog.
*******************************************************************************************************************************************/

#ifndef __CFONTBUTTON_H__
#define __CFONTBUTTON_H__

#include "cbutton.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// font button xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cfontbutton font-name="string" show-style="true|false" show-size="true|false" use-font="true|false" use-size="true|false">
//    ...
// </ccfontbutton>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_FONT_BUTTON_ELEMENT		("cfontbutton");
static CString XML_FONT_BUTTON_ATTR_FONT_NAME	("font-name");
static CString XML_FONT_BUTTON_ATTR_SHOW_STYLE	("show-style");
static CString XML_FONT_BUTTON_ATTR_SHOW_SIZE	("show-size");
static CString XML_FONT_BUTTON_ATTR_USE_FONT	("use-font");
static CString XML_FONT_BUTTON_ATTR_USE_SIZE	("use-size");

//-----------------------------------------------------------------------------------------------------------------------------------------
// font button listener
//-----------------------------------------------------------------------------------------------------------------------------------------
class CFontButtonListener : public CButtonListener
{
	// instanciation section
	public :

		CFontButtonListener		();
		virtual ~CFontButtonListener	() =0;

	// specific listener functions
	public :

		// called on inSender font button when the user selects the specified font name
		virtual void			OnSetFont			(CObject *inSender, CString &inFontName)	{ }

		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// class tag and metaclass declaration
DECLARE_GENERIC_METACLASS ('_fbn', CFontButtonListener, CButtonListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// font button definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CFontButton : public CButton
{
	// instanciation section
	public :
		
		CFontButton			(CContainer *inOwner=NULL, const CFontButtonListener *inListener=NULL);
		virtual ~CFontButton		();

	// protected instanciation process definition
	protected :

		// specific gtk widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// CObject redefinition
	protected :

		// expected CButtonListener
		virtual const CMetaClass *	ListenerMustBe			() const;

	// CButton redefinition
	public :

		// dialog box associated title
		virtual void			SetCaption 			(const CString &inCaption);
		virtual CString			GetCaption			() const;

	// font button specifics
	public :

		// font name		
		virtual bool			SetFontName			(const CString &inFontName);
		CString				GetFontName			() const;

		// show font style
		void				SetShowStyle			(const bool inShowStyle);
		bool				GetShowStyle			() const;

		// show size
		void				SetShowSize			(const bool inShowSize);
		bool				GetShowSize			() const;

		// use font
		virtual void			SetUseFont			(const bool inUseFont);
		bool				GetUseFont			() const;

		// use size
		virtual void			SetUseSize			(const bool inUseSize);
		bool				GetUseSize			() const;

	// CSerialized redefinition
	public :

		// CButton xml serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;
	// protected section
	protected :

		// static / dynamic event mapping
		static void			OnSetFont			(GtkFontButton *, gpointer);

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// class tag and metaclass declaration
DECLARE_DYNAMIC_METACLASS ('fnbn', CFontButton, CButton);


#endif
