/*******************************************************************************************************************************************
 cexpander.h
 
 CClass
 |--CSerialized
    |--CMetaModule
       |--CObject
          |--CComponent
   	     |--CControl
	        |--CWidget
	   	   |--CContainer
		      |--CExpander

 The GtkExpander binding i.e. a container which can hide its child.

*******************************************************************************************************************************************/

#ifndef __CEXPANDER_H__
#define __CEXPANDER_H__

#include "ccontainer.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// cexpander xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cexpander caption="string" expanded="true|false" spacing="UInt32">
//    ...
// </cexpander>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_CEXPANDER_ELEMENT 		("cexpander");
static CString XML_CEXPANDER_ATTR_CAPTION	("caption");
static CString XML_CEXPANDER_ATTR_EXPANDED	("expanded");
static CString XML_CEXPANDER_ATTR_SPACING	("spacing");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CExpanderListener class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CExpanderListener : public CWidgetListener
{
	// instanciation section
	public :

		CExpanderListener		();
		virtual ~CExpanderListener	() =0;
	
	// specific expander listener api
	public :

		// called when the inSender expander is activated i.e. expanded or collapsed
		virtual void			OnClick				(CObject *inSender)		{ }
	
		// generic metaclass association
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('_xpd', CExpanderListener, CWidgetListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// CExpander class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CExpander : public CContainer
{
	// instanciation section
	public :

		CExpander			(CContainer *inOwner=NULL, const CExpanderListener *inListener=NULL);
		virtual ~CExpander		();

	// protected instanciation process definition
	protected :

		// specific gtk widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// CObject redefinition
	protected :

		// expected CExpanderListener
		virtual const CMetaClass *	ListenerMustBe			() const;

	// CComponent redefinition
	public :

		// expected owner type : __metaclasses(CContainer)
		virtual CMetaClasses		OwnerMustBe			() const;

	// CButton specific functions
	public :

		// button caption (underline char to specify following char shortcut)
		virtual void			SetCaption			(const CString &inCaption);
		virtual CString			GetCaption			() const;

		// distance between expander and its child in pixels
		virtual void			SetSpacing			(const UInt32 inSpacing);
		UInt32				GetSpacing			() const;

		// expand, collapse
		virtual void			Expand				();
		virtual void			Collapse			();
		bool				IsExpanded			() const;

		// OnClick event sender
		virtual void			Click				();

	// CSerialized redefinition
	public :

		// CButton xml serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;
	
	// protected attributes
	protected :

		// static -> dynamic event resolution
		static void 			OnActivate			(GtkExpander *, gpointer);

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('xpdr', CExpander, CContainer);

#endif
