/*******************************************************************************************************************************************
 cdemomoduletreeview.c

 simple compilation directives :
 c++ -Wno-multichar -O2 -o treeview `pkg-config --cflags libgtkol-1.2` cdemomoduletreeview.c `pkg-config --libs libgtkol-1.2`

 This sample performs a simple treeview demonstration. The treeview is instanciated with a model handling a checkbox and a string i.e. 
 tree view items that own checkboxes and string values, both on each of them. The string field value is an editable part only when the
 checkbox is checked.
*******************************************************************************************************************************************/

#include "cdemomodule.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// the demo form has a menu item that is connected to this listener
//-----------------------------------------------------------------------------------------------------------------------------------------
class CMenuItemQuitListener : public CMenuItemListener 
{
	// called when the specified menu item is clicked
	virtual void OnClick (CObject *inSender)
	{
		// get the owner form by specifying the requested indirect owner type and close it
		static_cast <CForm *> (static_cast <CMenuItem *> (inSender) -> GetOwner (__metaclass(CForm))) -> Close ();
	}
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// the demo tree view is associated to this listener, so that we can handle interested events
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoTreeViewListener : public CTreeViewListener
{
	// called when the specified indexed boolean field value of the inSender tree view item is about to be toggled
	virtual void OnItemToggled (CObject *inSender, CObject *inItem, const size_t inIndex, Bool &ioDoChange)	
	{
		// retreive the tree view item instance ang get a reference on it
		CTreeViewItem &inTreeViewItem = *static_cast <CTreeViewItem *> (inItem);

		// in this sample demo, the 1 indexed field value is a string, the 0 indexed field value is a boolean; so set the editable
		// state of the string field value from the current check state of the boolean one...
		inTreeViewItem[1] = !inTreeViewItem[0];
	}
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDemoForm definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoForm : public CForm
{
	// instanciation section
	public :

		CDemoForm (CApplication *inOwner) : CForm (inOwner)
		{
			// set the form bounds (center the form over screen with 320x440 dimensions)
			SetBounds  (TBounds ((CApplication::GetScreenSize().w-320)/2, (CApplication::GetScreenSize().h-440)/2, 320, 440));

			// set the form caption
			SetCaption (CString("Tree View"));

			// instanciate a vertical box layout under the form and set some properties
			CVBoxLayout *VBoxLayout = new CVBoxLayout (this);
			VBoxLayout -> SetHomogeneous (false);
			VBoxLayout -> SetBoxPack     (BOXPACK_START, false, false, 0);

			// instanciate a menu bar under the layout and set the menu items (the quit menu is associated to a specific
			// listener in order to catch the click interested event, it has no predefined hot key associated)
			CMenuBar  *MenuBar  = new CMenuBar  (VBoxLayout);
			CMenuItem *MenuFile = new CMenuItem (MenuBar,  CString("_File"));
			CMenuItem *MenuQuit = new CMenuItem (MenuFile, CString("_Quit"), _HKNone_, new CMenuItemQuitListener());

			// instanciate a scrollview under the global layout
			VBoxLayout -> SetBoxPack (BOXPACK_START, true, true, 0);
			CScrollView *ScrollView = new CScrollView (VBoxLayout);

			// instanciate a treeview under the scrollview with the specified model : a boolean field value and a string one
			// foreach of the to be handled treeview items; associate our specific tree view listener
			CTreeView *TreeView = new CTreeView (ScrollView, _IFVBoolean_+_IFVString_, new CDemoTreeViewListener());

			// fill some tree view items into the newly allocated tree view, respect the expected treeview model
			CTreeViewItem &Item0  = *new CTreeViewItem (TreeView);
			Item0 [0] = false;
			Item0 [1] = CString("Gtk");
			CTreeViewItem &Item01 = *new CTreeViewItem (&Item0);
			Item01[0] = false;
			Item01[1] = CString("gtk-list@gnome.org");
			CTreeViewItem &Item02 = *new CTreeViewItem (&Item0);
			Item02[0] = false;
			Item02[1] = CString("gtk-app-devel-list@gnome.org");
			CTreeViewItem &Item03 = *new CTreeViewItem (&Item0);
			Item03[0] = false;
			Item03[1] = CString("gtk-devel-list@gnome.org");
			CTreeViewItem &Item04 = *new CTreeViewItem (&Item0);
			Item04[0] = false;
			Item04[1] = CString("gtk-i18n-list@gnome.org");
			CTreeViewItem &Item05 = *new CTreeViewItem (&Item0);
			Item05[0] = false;
			Item05[1] = CString("gtk-doc-list@gnome.org");
			CTreeViewItem &Item1  = *new CTreeViewItem (TreeView);
			Item1 [0] = false;
			Item1 [1] = CString("GtkOL");
			CTreeViewItem &Item10 = *new CTreeViewItem (&Item1);
			Item10[0] = false;
			Item10[1] = CString("libgtkol@lists.tuxfamily.org");
			CTreeViewItem &Item11 = *new CTreeViewItem (&Item1);
			Item11[0] = false;
			Item11[1] = CString("libgtkol-dev@lists.tuxfamily.org");
 	
			// show the form (CForm is the only gtkol component that is not automatically shown)
			Show ();
		}
};

/*******************************************************************************************************************************************
********************************************************************************************************************************************
 The purpose of the following part is only to dynamically link the previous demo definition to this gui demo core; it is really not the 
 purpose of this sample code. It is shown only as part of the global comprehension of the demo core mechanism itself.
********************************************************************************************************************************************
*******************************************************************************************************************************************/

const static TDemoModuleDescription DEMO_MODULE_DESCRIPTION = 
{ 
	CString ("Tree View"), 
	CString ("This sample performs a simple treeview demonstration. The treeview is instanciated with a model handling a checkbox\n") +
		 "and a string i.e. tree view items that own checkboxes and string field values, both for each of the items.\n" +
		 "The string field value is an editable part only when the checkbox is checked.",
	DEMO_MODULES_PATH + "treeview.cpp"
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDemoModuleTreeView class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoModuleTreeView : public CDemoModule
{
	public :

		// constructor		
		CDemoModuleTreeView () : m_Form (NULL) { }

		// give the demo module description
		virtual TDemoModuleDescription	GetDescription () const { return DEMO_MODULE_DESCRIPTION; }
		
		// run the encapsulated demo module
		virtual void Run (CApplication *inOwner) { if (m_Form == NULL) m_Form = new CDemoForm (inOwner); else m_Form -> Show(); }

		// stop the demo
		virtual void Stop () { if (m_Form != NULL) m_Form -> Close(); }

	protected :

		// the encapsulated demo module form
		CDemoForm *m_Form;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// classtag and metaclass declaration
DECLARE_DYNAMIC_METACLASS ('dotw', CDemoModuleTreeView, CDemoModule);

// metaclass code resolution
RESOLVE_DYNAMIC_METACLASS (CDemoModuleTreeView);

// demo module export declaration
DECLARE_METAMODULE_EXPORT (CDemoModuleTreeView);

