/*******************************************************************************************************************************************
 cdemomodulehelloworld.c

 simple compilation directives :
 c++ -Wno-multichar -O2 -o helloworld `pkg-config --cflags libgtkol-1.2` cdemomodulehelloworld.c `pkg-config --libs libgtkol-1.2`

 This sample is the simpliest one. It instanciates a main form with a menu bar and an associated menu item listener.
*******************************************************************************************************************************************/

#include "cdemomodule.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// the demo form has a menu item that is connected to this listener
//-----------------------------------------------------------------------------------------------------------------------------------------
class CMenuItemQuitListener : public CMenuItemListener 
{
	// called when the specified menu item is clicked
	virtual void OnClick (CObject *inSender)
	{
		// get the owner form by specifying the requested indirect owner type and close it
		static_cast <CForm *> (static_cast <CMenuItem *> (inSender) -> GetOwner (__metaclass(CForm))) -> Close ();
	}
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDemoForm definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoForm : public CForm
{
	// instanciation section
	public :

		CDemoForm (CApplication *inOwner) : CForm (inOwner)
		{
			// set the form bounds (center the form over screen with 320x240 dimensions)
			SetBounds  (TBounds ((CApplication::GetScreenSize().w-320)/2, (CApplication::GetScreenSize().h-240)/2, 320, 240));

			// set the form caption
			SetCaption (CString("Hello World"));

			// instanciate a vertical box layout under the form and set some properties
			CVBoxLayout *VBoxLayout = new CVBoxLayout (this);
			VBoxLayout -> SetHomogeneous (false);
			VBoxLayout -> SetBoxPack     (BOXPACK_START, false, false, 0);

			// instanciate a menu bar under the layout and set the menu items (the quit menu is associated to a specific
			// listener in order to catch the click interested event, it has no predefined hot key associated)
			CMenuBar  *MenuBar  = new CMenuBar  (VBoxLayout);
			CMenuItem *MenuFile = new CMenuItem (MenuBar,  CString("_File"));
			CMenuItem *MenuQuit = new CMenuItem (MenuFile, CString("_Quit"), _HKNone_, new CMenuItemQuitListener());

			// show the form (CForm is the only gtkol component that is not automatically shown)
			Show ();
		}
};

/*******************************************************************************************************************************************
********************************************************************************************************************************************
 The purpose of the following part is only to dynamically link the previous demo definition to this gui demo core; it is really not the 
 purpose of this sample code. It is shown only as part of the global comprehension of the demo core mechanism itself.
********************************************************************************************************************************************
*******************************************************************************************************************************************/

// demo module constant description declaration
const static TDemoModuleDescription DEMO_MODULE_DESCRIPTION = 
{ 
	CString ("Hello World"), 
	CString ("This demonstration is the simpliest one. It launches a single form with a specific menu item listener\nthat catches ") +
		 "click events.",
	DEMO_MODULES_PATH + "helloworld.cpp",
	NULL
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDemoModuleHelloWorld definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoModuleHelloWorld : public CDemoModule
{
	public :
		
		// constructor
		CDemoModuleHelloWorld () : m_Form (NULL) { }

		// give the demo module description
		virtual TDemoModuleDescription GetDescription () const { return DEMO_MODULE_DESCRIPTION; }

		// run the encapsulated demo module
		virtual void Run (CApplication *inOwner) { if (m_Form == NULL) m_Form = new CDemoForm (inOwner); else m_Form -> Show(); }

		// stop the demo
		virtual void Stop () { if (m_Form != NULL) m_Form -> Close(); }

	protected :

		// the encapsulated demo module form
		CDemoForm *m_Form;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// classtag and metaclass declaration
DECLARE_DYNAMIC_METACLASS ('dohl', CDemoModuleHelloWorld, CDemoModule);

// metaclass code resolution
RESOLVE_DYNAMIC_METACLASS (CDemoModuleHelloWorld);

// demo module export declaration
DECLARE_METAMODULE_EXPORT (CDemoModuleHelloWorld);

