/*******************************************************************************************************************************************
 cfilechooserbutton.c
*******************************************************************************************************************************************/

#include "cfilechooserbutton.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_GENERIC_METACLASS (CFileChooserButtonListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CFileChooserButtonListener::CFileChooserButtonListener ()
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CFileChooserButtonListener::~CFileChooserButtonListener ()
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CFileChooserButton);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CFileChooserButton::CFileChooserButton 	   (CContainer *inOwner, const GtkFileChooserAction inGtkFileChooserAction, 
					    const CFileChooserButtonListener *inListener)
		   :CButton	     	   (NULL, inListener),
		    m_GtkFileChooserAction (inGtkFileChooserAction)
{
	// set this instance owner and launch the gtk instanciation process
	if (inOwner != NULL) SetOwner (inOwner);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CFileChooserButton::~CFileChooserButton ()
{
	// deletion coherence requested
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget instanciation
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CFileChooserButton::PerformWidgetInstanciate ()
{
	// ok
	return ::gtk_file_chooser_button_new_with_backend ("File Chooser", m_GtkFileChooserAction, "~");
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget initialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CFileChooserButton::PerformWidgetInitialize ()
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// specific signals connections


	// generic call
	CButton::PerformWidgetInitialize ();

	// title affectation
	SetCaption (CString("File Chooser"));
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// expected listener
//-----------------------------------------------------------------------------------------------------------------------------------------
const CMetaClass * CFileChooserButton::ListenerMustBe () const
{
	return __metaclass(CFileChooserButtonListener);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// dialog box title
//-----------------------------------------------------------------------------------------------------------------------------------------
void CFileChooserButton::SetCaption (const CString &inCaption)
{
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// dialog box title
//-----------------------------------------------------------------------------------------------------------------------------------------
void CFileChooserButton::GetCaption () const
{
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// xml serialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CFileChooserButton::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	// generic call first
	CButton::Serialize (ioXMLElementNode, inMode);

	// request analyse
	switch (inMode)
	{
		// xml dump
		case XML_WRITE :
		{
		}
		break;

		// xml load
		case XML_READ :
		{
		}
		break;
	}
}


