/*******************************************************************************************************************************************
 ctogglebutton.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl			 |
	        |--CWidget			 |--CWidgetListener
		   |--CContainer		    |
		      |--CButton		    |--CButtonListener
			 |--CToggleButton

 Standard toggle button definition.
*******************************************************************************************************************************************/

#ifndef __CTOGGLEBUTTON_H__
#define __CTOGGLEBUTTON_H__

#include "cbutton.h"


//-----------------------------------------------------------------------------------------------------------------------------------------
// ctogglebutton xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <ctogglebutton checked="bool">
//    ...
// </ctogglebutton>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_TOGGLEBUTTON_ELEMENT		("ctogglebutton");
static CString XML_TOGGLEBUTTON_ATTR_PRESS	("checked");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CToggleButton class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CToggleButton : public CButton
{
	// instanciation section
	public :

		CToggleButton			(CContainer *inOwner=NULL, const CButtonListener *inListener=NULL);
		virtual ~CToggleButton		();

	// protected instanciation process definition
	protected :

		// specific gtk widget instanciation
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// specific toggle functions
	public :

		// toggle state; true if pressed
		virtual void			Check				(const bool inToggle=true);
		virtual bool			IsChecked			() const;

	// CSerialized redefinition
	public :

		// xml toggle button serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// class tag and metaclass declaration
DECLARE_DYNAMIC_METACLASS ('tbtn', CToggleButton, CButton);

#endif
