/*******************************************************************************************************************************************
 chboxlayout.h
 
 CClass	
 |--CSerialized
    |--CMetaModule
       |--CObject
          |--CComponent
	     |--CControl
	        |--CWidget
		   |--CContainer
		      |--CLayout
		         |--CBoxLayout
			    |--CHBoxLayout

 Horizontal Box layout definition.
*******************************************************************************************************************************************/

#ifndef __CHBOXLAYOUT_H__
#define __CHBOXLAYOUT_H__

#include "cboxlayout.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// CHBoxLayout class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CHBoxLayout : public CBoxLayout
{
	// instanciation section
	public :

		CHBoxLayout			(CContainer *inOwner=NULL, const CWidgetListener *inListener=NULL);
		virtual ~CHBoxLayout		();

	// specific widget instanciation
	protected :

		// widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();

	// CLayout redefinition
	public :

		// this function returns the insertion index of a given potential new child from the layout's relative coordinates
		// specifications; checks if a control has to be inserted before or after the widget referenced at the given position
		virtual SInt16			GetDropIndexAtPoint		(const TPoint &inRelativePoint, 
										 const CControl *inCandidate) const;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('hbly', CHBoxLayout, CBoxLayout);

#endif
