/*******************************************************************************************************************************************
 ccolorbutton.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl		         |
	        |--CWidget		         |--CWidgetListener
		   |--CContainer	   	    |
		      |--CButton		    |--CButtonListener
			 |--CColorButton	       |--CColorButtonListener

 A button to launch a color selection dialog.
*******************************************************************************************************************************************/

#ifndef __CCOLORBUTTON_H__
#define __CCOLORBUTTON_H__

#include "cbutton.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// color button xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <ccolorbutton argb="UInt16,Uint16,UInt16,UInt16" use-aplha="true|false">
//    ...
// </ccolorbutton>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_COLOR_BUTTON_ELEMENT			("ccolorbutton");
static CString XML_COLOR_BUTTON_ATTR_ARGB		("argb");
static CString XML_COLOR_BUTTON_ATTR_USE_ALPHA		("use-alpha");

//-----------------------------------------------------------------------------------------------------------------------------------------
// color button listener
//-----------------------------------------------------------------------------------------------------------------------------------------
class CColorButtonListener : public CButtonListener
{
	// instanciation section
	public :

		CColorButtonListener		();
		virtual ~CColorButtonListener	() =0;

	// specific listener functions
	public :

		// called on inSender color button when the user selects the inGdkColor color and the associated inAlpha value
		virtual void			OnSetColor			(CObject *inSender, UInt16 inAlpha, 
										 GdkColor inGdkColor)	{ }

		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// class tag and metaclass declaration
DECLARE_GENERIC_METACLASS ('_cbn', CColorButtonListener, CButtonListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// color button definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CColorButton : public CButton
{
	// instanciation section
	public :
		
		CColorButton			(CContainer *inOwner=NULL, const CColorButtonListener *inListener=NULL);
		virtual ~CColorButton		();

	// protected instanciation process definition
	protected :

		// specific gtk widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// CObject redefinition
	protected :

		// expected CButtonListener
		virtual const CMetaClass *	ListenerMustBe			() const;

	// CButton redefinition
	public :

		// dialog box associated title
		virtual void			SetCaption 			(const CString &inCaption);
		virtual CString			GetCaption			() const;

	// color button specifics
	public :

		// color button selected color
		virtual void			SetColor			(const GdkColor &inGdkColor);
		GdkColor			GetColor			() const;

		// alpha value of the selected color
		virtual void			SetAlpha			(const UInt16 inAlpha);
		UInt16				GetAlpha			() const;

		// use alpha attribute
		virtual void			SetUseAlpha			(const bool inUseAlpha);
		bool				GetUseAlpha			() const;

	// CSerialized redefinition
	public :

		// CButton xml serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;
	// protected section
	protected :

		// static / dynamic event mapping
		static void			OnSetColor			(GtkColorButton *, gpointer);

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// class tag and metaclass declaration
DECLARE_DYNAMIC_METACLASS ('cobn', CColorButton, CButton);

#endif
