/*
 * @(#)SingletonStore.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.classes.v1;



/**
 * Aids pluggable factories and related classes by being a central repository
 * for storing a singleton, and creating means to load and change the singleton.
 *
 * @author  Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version $Date: 2003/02/10 22:52:36 $
 * @since   March 30, 2002
 */
public class SingletonStore extends AbstractSingleStore
{
    private Class defaultImplementation;
    private String sysPropertyKey;
    
    
    /**
     * Constructor specifying all the parameters for using a singleton in this
     * framework.
     *
     * @param instanceOf singletons must be of this class.
     * @param defaultImpl the class which will be used if no valid
     *      implementation class can be found.
     * @param sysPropertyKey the system property key to reference for the name
     *      of the implementation class.
     */
    public SingletonStore( Class instanceOf, Class defaultImpl,
            String sysPropertyKey )
    {
        super( instanceOf );
        this.defaultImplementation = defaultImpl;
        this.sysPropertyKey = sysPropertyKey;
    }
    
    
    /**
     * Sets the inner singleton to the default, which pulls from the system
     * property key.
     */
    public void setDefaultSingleton()
    {
        setSingletonFromProperty( this.sysPropertyKey );
    }
    
    
    /**
     * Set the singleton to the class specified in the given system
     * property; if the class is invalid, then the default singleton class will
     * be used instead.
     *
     * @param key the System property to reference for the classname to
     *      instantiate.  It is passed to <tt>ClassLoadHelper</tt>
     * @exception IllegalArgumentException if <tt>key</tt> is <tt>null</tt>.
     * @see ClassLoadHelper#createObjectFromProperty( String, Class, boolean )
     */
    public void setSingletonFromProperty( String key )
    {
        setSingleton( createFromProperty( key, this.defaultImplementation ) );
    }
}

