/*
 *  @(#)StateType.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.mbtf.v1.ant;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.taskdefs.Definer;

import java.util.Vector;

import net.sourceforge.groboutils.mbtf.v1.IValidate;
import net.sourceforge.groboutils.mbtf.v1.ISystem;

import net.sourceforge.groboutils.mbtf.v1.assembler.AsmblState;


/**
 * An ant datatype encapsulating the IState instance.  This includes an
 * <tt>execute()</tt> method to allow for this to be defined in a
 * &lt;typedef&gt; declaration, rather than inside a target as a
 * &lt;datatype&gt; declaration.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:25 $
 * @since      June 13, 2002
 */
public class StateType extends AbstractStateMachineType
{
    public static final String DEFAULT_ANT_NAME = "mbtf.state";
    
    
    private Vector transitions = new Vector();
    private boolean startState = false;
    private boolean finalState = false;
    
    
    public static class RefTransitionType
    {
        private String name;
        
        public void setName( String name )
        {
            this.name = name;
        }
        
        public String getName()
        {
            return this.name;
        }
    }
    public void addTransition( RefTransitionType trans )
    {
        if (trans != null)
        {
            this.transitions.addElement( trans );
        }
    }
    
    
    public String[] getTransitionNames()
    {
        if (isReference())
        {
            return ((StateType)getCheckedRef(
                StateType.class, DEFAULT_ANT_NAME )).
                getTransitionNames();
        }
        
        String[] s = new String[ this.transitions.size() ];
        for (int i = s.length; --i >= 0;)
        {
            s[i] = ((RefTransitionType)this.transitions.elementAt( i )).
                getName();
        }
        return s;
    }
    
    
    public void setStartState( boolean on )
    {
        this.startState = on;
    }
    
    
    public boolean getStartState()
    {
        if (isReference())
        {
            return ((StateType)getCheckedRef(
                StateType.class, DEFAULT_ANT_NAME )).
                getStartState();
        }
        return this.startState;
    }
    
    
    public void setFinalState( boolean on )
    {
        this.finalState = on;
    }
    
    
    public boolean getFinalState()
    {
        if (isReference())
        {
            return ((StateType)getCheckedRef(
                StateType.class, DEFAULT_ANT_NAME )).
                getFinalState();
        }
        return this.finalState;
    }
    
    
    public AsmblState createState()
            throws BuildException
    {
        if (isReference())
        {
            return ((StateType)getCheckedRef(
                StateType.class, DEFAULT_ANT_NAME )).
                createState();
        }

        verifySettings();
        
        AsmblState as = new AsmblState();
        as.setName( getName() );
        as.setIsStartState( getStartState() );
        as.setIsFinalState( getFinalState() );

        IValidate v[] = getValidates();
        for (int i = 0; i < v.length; ++i)
        {
            as.addValidate( v[i] );
        }
        
        String names[] = getTransitionNames();
        for (int i = 0; i < names.length; ++i)
        {
            as.addTransitionName( names[i] );
        }
        
        return as;
    }
}

