/**
 * @file libgnurdf/internal.h GNUpdate RDF library.
 * 
 * $Id: internal.h,v 1.4 2001/09/20 20:00:48 chipx86 Exp $
 *
 * @Copyright (C) 1999-2001 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _LIBGNURDF_INTERNAL_H_
#define _LIBGNURDF_INTERNAL_H_

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#endif

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

#ifdef WITH_LEAKBUG
# include <leakbug.h>
#endif

#include <stdio.h>
#include <errno.h>

/* This should fix things with older versions of libxml. */
#ifndef xmlChildrenNode
# define xmlChildrenNode childs
# define xmlRootNode root
#endif

void rdfInitializeParser(void);
void rdfUninitializeParser(void);

#endif /* _LIBGNURDF_INTERNAL_H_ */

