/**
 * @file libgnurdf/alt.h Alternate container functions
 *
 * $Id: alt.h,v 1.3 2001/08/23 08:51:22 chipx86 Exp $
 *
 * @Copyright (C) 1999-2001 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _LIBGNURDF_ALT_H_
#define _LIBGNURDF_ALT_H_

#include <libgnurdf/types.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Creates a new alternative container.
 *
 * @param parent   The parent which will hold the alternative container.
 * @param property The name of the alternative container's property.
 * @param ns       The alternative container's namespace.
 *
 * @return The new alternative container.
 */
RdfAlt *rdfCreateAlt(RdfElement *parent, const char *property,
					 RdfNamespace *ns);

/**
 * Adds a property to the alternative container.
 *
 * @param alt      The alternative container.
 * @param property The property's name.
 * @param ns       The property's namespace.
 * @param value    The value of the property, if not NULL.
 * @param element  The property's element, if not NULL.
 *
 * @return The new element.
 */
RdfElement *rdfAltAddValue(RdfAlt *alt, const char *property,
                           RdfNamespace *ns, const char *value,
                           RdfElement *element);

#ifdef __cplusplus
}
#endif

#endif /* _LIBGNURDF_ALT_H_ */

