/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.VBox;
/**
 * This widget provides an entry box with history and a button which can pop up a
 * file selector dialog box.  It also accepts DND drops from the filemanager and 
 * other sources.
 */
public class FileEntry extends VBox {
	/**
	 * Create a new FileEntry widget
	 */
	public FileEntry(String historyID, String browseDialogTitle) {
		super(gnome_file_entry_new(historyID, browseDialogTitle));
	}

	/**
	 * Construct a new FileEntry from a handle to a native resource.
	 */
	public FileEntry(Handle handle) {
	    super(handle);
	}
	
	/**
	 * Returns the Gnome Entry widget.
	 */
	public Entry getEntry() {
		Handle hndl = gnome_file_entry_gnome_entry(getHandle());
		GObject obj = getGObjectFromHandle(hndl);
		if (null != obj)
			return (Entry)obj;
		return new Entry(hndl);
	}

	/**
	 * Sets the title of the browse dialog.
	 */
	public void setTitle(String browseDialogTitle) {
		gnome_file_entry_set_title(getHandle(), browseDialogTitle);
	}

	/**
	 * Sets the default path for the browse dialog.
	 */
	public void setDefaultPath(String path) {
		gnome_file_entry_set_default_path(getHandle(), path);
	}

	/**
	 * Sets whether this is a directory only entry.
	 */
	public void setDirectorySelection(boolean directoryEntry) {
		gnome_file_entry_set_directory_entry(getHandle(), directoryEntry);
	}

	/**
	 * Gets the full absolute path of the file from the entry.
	 */
	public String getFullPath(boolean fileMustExist) {
		return gnome_file_entry_get_full_path(getHandle(), fileMustExist);
	}

	/**
	 * Sets the modality of the browse dialog.
	 */
	public void setModal(boolean isModal) {
		gnome_file_entry_set_modal(getHandle(), isModal);
	}

	/**
	 * Returns if the browse dialog is modal.
	 */
	public boolean getModal() {
		return gnome_file_entry_get_modal(getHandle());
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_file_entry_get_type());
	}


	native static final protected int gnome_file_entry_get_type();
	native static final protected Handle gnome_file_entry_new(String historyId, String browseDialogTitle);
	native static final protected Handle gnome_file_entry_gnome_entry(Handle fentry);
	native static final protected Handle gnome_file_entry_gtk_entry(Handle fentry);
	native static final protected void gnome_file_entry_set_title(Handle fentry, String browseDialogTitle);
	native static final protected void gnome_file_entry_set_default_path(Handle fentry, String path);
	native static final protected void gnome_file_entry_set_directory_entry(Handle fentry, boolean directoryEntry);
	native static final protected boolean gnome_file_entry_get_directory_entry(Handle fentry);
	native static final protected String gnome_file_entry_get_full_path(Handle fentry, boolean fileMustExist);
	native static final protected void gnome_file_entry_set_filename(Handle fentry, String filename);
	native static final protected void gnome_file_entry_set_modal(Handle fentry, boolean isModal);
	native static final protected boolean gnome_file_entry_get_modal(Handle fentry);

}
