/* readonlymap.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GEE_READONLYMAP_H__
#define __GEE_READONLYMAP_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/map.h>
#include <gee/set.h>
#include <gee/collection.h>

G_BEGIN_DECLS


#define GEE_TYPE_READ_ONLY_MAP (gee_read_only_map_get_type ())
#define GEE_READ_ONLY_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMap))
#define GEE_READ_ONLY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMapClass))
#define GEE_IS_READ_ONLY_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_MAP))
#define GEE_IS_READ_ONLY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_MAP))
#define GEE_READ_ONLY_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMapClass))

typedef struct _GeeReadOnlyMap GeeReadOnlyMap;
typedef struct _GeeReadOnlyMapClass GeeReadOnlyMapClass;
typedef struct _GeeReadOnlyMapPrivate GeeReadOnlyMapPrivate;

/**
 * Represents a read-only collection of key/value pairs.
 */
struct _GeeReadOnlyMap {
	GObject parent_instance;
	GeeReadOnlyMapPrivate * priv;
};
struct _GeeReadOnlyMapClass {
	GObjectClass parent_class;
};

GeeReadOnlyMap* gee_read_only_map_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMap* map);
void gee_read_only_map_set_map (GeeReadOnlyMap* self, GeeMap* value);
GType gee_read_only_map_get_type (void);


G_END_DECLS

#endif
