/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include "types.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "log.h"
#include "rmd160.h"
#include "tt.h"


u32 tt_hash(TT *tt)
{
  u32 hash;
  RMD160_CONTEXT ctx;
  byte *block;
  unsigned int len;

  if (!tt_has_data(tt)) return(0);

  rmd160_init(&ctx);
  rmd160_write(&ctx, (byte *) &tt->size, sizeof(tt->size));
  
  if (tt->data_is_internal) rmd160_write(&ctx, tt->data, tt->size);
  else
  {
    if (tt_size(tt) <= (TT_GENERIC_BLOCK_SIZE << 1))
    {
      len = tt_size(tt);
      block = malloc(len);
      tt_data_get_bytes(tt, block, 0, tt_size(tt));
    }
    else
    {
      len = (TT_GENERIC_BLOCK_SIZE << 1);
      block = malloc(len);
      tt_data_get_bytes(tt, block, 0, TT_GENERIC_BLOCK_SIZE);
      tt_data_get_bytes(tt, block + TT_GENERIC_BLOCK_SIZE,
                        tt_size(tt) - TT_GENERIC_BLOCK_SIZE,
                        TT_GENERIC_BLOCK_SIZE);
    }
    
    rmd160_write(&ctx, block, len);
    free(block);
  }

  rmd160_final(&ctx);

  /* Fold */

  hash = *((u32 *) &ctx.buf[0]);
  hash ^= *((u32 *) &ctx.buf[4]);
  hash ^= *((u32 *) &ctx.buf[8]);
  hash ^= *((u32 *) &ctx.buf[12]);
  hash ^= *((u32 *) &ctx.buf[16]);
  
  return(hash);
}


u32 tt_hash_all(TT *tt)
{
  u32 hash;
  TT *tt_child;

  hash = 0;
  
  /* Hash children */

  for (tt_child = tt_get_first_child(tt); tt_child; tt_child = tt_get_next(tt_child))
    hash ^= tt_hash_all(tt_child);

  /* Hash self */

  hash ^= tt_hash(tt);
  return(hash);
}
