/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include "comm.h"
#include "sock.h"
#include <stdlib.h>


COMM *_comm_alloc()
{
  COMM *comm;
  
  comm = malloc(sizeof(*comm));
  memset(comm, 0, sizeof(*comm));

  comm->queue_in = tt_new();
  comm->queue_out = tt_new();
  
  return(comm);
}


COMM *comm_new()
{
  COMM *comm;
  
  comm = _comm_alloc();
  comm->s = sock_new();
  comm_limits(comm, 256, 256000, 256);
  return(comm);
}


COMM *comm_accepting_new(int port)
{
  COMM *comm;
  
  comm = _comm_alloc();
  comm->s = sock_accepting_new(port);
  comm_limits(comm, 256, 256000, 256);
  return(comm);
}


COMM *comm_pipe_new()
{
  COMM *comm;

  comm = _comm_alloc();
  comm->s = sock_pipe_new();
  return(comm);
}


COMM *comm_new_with_port(int port)
{
  COMM *comm;
  
  comm = _comm_alloc();
  comm->s = sock_new_with_port(port);
  comm_limits(comm, 256, 256000, 256);
  return(comm);
}


COMM *comm_new_with_sock(SOCK *s)
{
  COMM *comm;

  comm = _comm_alloc();
  comm->s = s;
  comm_limits(comm, 256, 256000, 256);
  return(comm);
}


void comm_del(COMM *comm)
{
  sock_del(comm->s);
  if (comm->root_in) tt_del(comm->root_in);  /* NOTE: Set to zero when queued */
  if (comm->root_out) tt_del(comm->root_out);  /* NOTE: Set to zero when sent */
  tt_del(comm->queue_in);
  tt_del(comm->queue_out);
  free(comm);
}
