/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#ifndef _FLUX_H
#define _FLUX_H 1

# ifdef LIBFLUX_BUILD

/* --- Timer function substitutions ---*/

# ifndef HAVE_TIMERCMP
#  define timercmp(a, b, CMP)                   \
  (((a)->tv_sec == (b)->tv_sec) ?                 \
   ((a)->tv_usec CMP (b)->tv_usec) :                \
      ((a)->tv_sec CMP (b)->tv_sec))
# endif

# ifndef HAVE_TIMERADD
#  define timeradd(a, b, result) \
do \
{ \
        (result)->tv_sec = (a)->tv_sec + (b)->tv_sec;           \
        (result)->tv_usec = (a)->tv_usec + (b)->tv_usec;            \
        if ((result)->tv_usec >= 1000000)               \
  { \
        ++(result)->tv_sec;                 \
        (result)->tv_usec -= 1000000;               \
  } \
} \
while (0)                                                                   
# endif

# ifndef HAVE_TIMERSUB  
#  define timersub(a, b, result) \
do \
{ \
                          \
        (result)->tv_sec = (a)->tv_sec - (b)->tv_sec;           \
        (result)->tv_usec = (a)->tv_usec - (b)->tv_usec;            \
        if ((result)->tv_usec < 0) \
    { \
              --(result)->tv_sec;                 \
              (result)->tv_usec += 1000000;               \
    } \
} \
while (0)                                                                   
# endif

/* --- Build-time includes --- */

# include "types.h"
#  include "cgi.h"
/* # include "cipher.h" */
# include "comm.h"
# include "fifobuf.h"
/* # include "irc.h" */
# include "log.h"
# include "mem.h"
# include "tt.h"
# include "mt.h"
/* # include "random.h" */
/* # include "rmd160.h" */
# include "sock.h"
# include "fstring.h"
/* # include "tn.h" */
/* # include "url.h" */
/* # include "xml.h" */
# include "proxy.h"

#else  /* !LIBFLUX_BUILD */

/* --- Application run-time includes --- */

# include <flux/types.h>
#  include <flux/cgi.h>
/* # include <flux/cipher.h> */
# include <flux/comm.h>
# include <flux/fifobuf.h>
/* # include <flux/irc.h> */
# include <flux/log.h>
# include <flux/mem.h>
# include <flux/tt.h>
# include <flux/mt.h>
/* # include <flux/random.h> */
/* # include <flux/rmd160.h> */
# include <flux/sock.h>
# include <flux/fstring.h>
/* # include <flux/tn.h> */
/* # include <flux/url.h> */
/* # include <flux/xml.h> */
# include <flux/proxy.h>
#endif

/* --- Global Flux functions --- */

char *flux_get_package();
char *flux_get_version();
char *flux_get_build_host();
char *flux_get_build_os();
char *flux_get_build_cpu();
char *flux_get_build_host_name();
char *flux_get_build_time();

#endif
