/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


int file_line_skip(FILE *in)
{
  int c;
  
  for (;;)
  {
    c = fgetc(in);
    if (c == '\n' || c == EOF) break;
  }

  return(c);
}


/* FUNCTION: afgets
 *
 * PARAMETERS: in, len_max
 *
 * DESCRIPTION: Like fgets(), but allocates space for the string read. Reads
 * at most len_max bytes, if len_max == 0, reads any amount. Does not store
 * the terminating newline, like fgets() does. If len_max cannot hold all
 * characters, skips rest of input line.
 *
 * RETURNS: Allocated string if successful, NULL on failure.
 */

char *afgets(FILE *in, int len_max)
{
  char *ret;
  char buf[1024];
  int len_read, len_this;
  
  for (len_read = 0, ret = 0; ; )
  {
    if (!(fgets(buf, 1024, in))) break;
    len_this = strlen(buf);

    if (len_max && len_read + len_this >= len_max)
    {
      ret = realloc(ret, len_max + 1);
      memcpy(ret + len_read, buf, len_max - len_read);
      len_read = len_max;
      if (*(ret + len_read - 1) != '\n' &&
          *(ret + len_read) != '\n') file_line_skip(in);
      break;
    }
    else
    {
      ret = realloc(ret, len_read + len_this);
      memcpy(ret + len_read, buf, len_this);
      len_read += len_this;
    }

    if (len_this < 1023) break;
  }

  if (!ret) return(0);

  if (*(ret + len_read - 1) == '\n') *(ret + len_read - 1) = 0;
  else *(ret + len_read) = 0;

  if (!strlen(ret)) 
  {
    free(ret);
    return(0);
  }
  
  return(ret);
}
