/* lda-schema-to-gconf.c generated by valac, the Vala compiler
 * generated from lda-schema-to-gconf.vala, do not modify */

/*
 * Desktop Agnostic Library: Desktop Agnostic to GConf schema converter.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <libdesktop-agnostic/config.h>
#include <libdesktop-agnostic/desktop-agnostic.h>
#include <glib/gstdio.h>
#include <stdio.h>

#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



char* schema_type_to_string (GType type);
void value_array_to_string (GValue* src_value, GValue* dest_value);
static void _value_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
gint _main (char** args, int args_length1);
static int _vala_strcmp0 (const char * str1, const char * str2);



char* schema_type_to_string (GType type) {
	char* result;
	if (type == G_TYPE_BOOLEAN) {
		result = g_strdup ("bool");
		return result;
	} else {
		if (type == G_TYPE_INT) {
			result = g_strdup ("int");
			return result;
		} else {
			if (type == G_TYPE_FLOAT) {
				result = g_strdup ("float");
				return result;
			} else {
				if (type == G_TYPE_STRING) {
					result = g_strdup ("string");
					return result;
				} else {
					if (type == G_TYPE_VALUE_ARRAY) {
						result = g_strdup ("list");
						return result;
					} else {
						result = g_strdup ("string");
						return result;
					}
				}
			}
		}
	}
}


void value_array_to_string (GValue* src_value, GValue* dest_value) {
	GValueArray* arr;
	GString* res;
	GValue _tmp3_;
	GValue _tmp2_ = {0};
	arr = g_value_get_boxed (src_value);
	res = g_string_new ("[");
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GValue val;
				GValue _tmp1_ = {0};
				GValue val_str;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < arr->n_values)) {
					break;
				}
				val = *g_value_array_get_nth (arr, i);
				g_assert (g_value_type_transformable (G_VALUE_TYPE (&val), G_TYPE_STRING));
				val_str = (g_value_init (&_tmp1_, G_TYPE_STRING), _tmp1_);
				g_value_transform (&val, &val_str);
				if (i != 0) {
					g_string_append (res, ",");
				}
				g_string_append (res, g_value_get_string (&val_str));
				G_IS_VALUE (&val_str) ? (g_value_unset (&val_str), NULL) : NULL;
			}
		}
	}
	g_string_append (res, "]");
	*dest_value = (_tmp3_ = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, res->str), _tmp2_), G_IS_VALUE (dest_value) ? (g_value_unset (dest_value), NULL) : NULL, _tmp3_);
	_g_string_free0 (res);
}


static void _value_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	value_array_to_string (src_value, dest_value);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gint _main (char** args, int args_length1) {
	gint result;
	GError * _inner_error_;
	const char* current_group;
	const char* current_key;
	_inner_error_ = NULL;
	current_group = NULL;
	current_key = NULL;
	if (args_length1 < 2) {
		result = 1;
		return result;
	}
	g_value_register_transform_func (G_TYPE_VALUE_ARRAY, G_TYPE_STRING, _value_array_to_string_gvalue_transform);
	{
		GType ct = 0UL;
		DesktopAgnosticConfigSchema* schema;
		GString* gconf;
		DesktopAgnosticConfigSchema* _tmp0_;
		DesktopAgnosticConfigSchema* _tmp1_;
		GString* _tmp2_;
		schema = NULL;
		gconf = NULL;
		ct = desktop_agnostic_module_loader_load (desktop_agnostic_module_loader_get_default (), "libda-cfg-gconf");
		if (ct == G_TYPE_INVALID) {
			g_critical ("lda-schema-to-gconf.vala:98: The GConf configuration module needs to be installed for %s to function correctly.", args[0]);
			result = 1;
			_g_object_unref0 (schema);
			_g_string_free0 (gconf);
			return result;
		}
		if (!g_file_test (args[1], G_FILE_TEST_IS_REGULAR)) {
			g_critical ("lda-schema-to-gconf.vala:105: The schema file '%s' does not seem to exist.", args[1]);
			result = 1;
			_g_object_unref0 (schema);
			_g_string_free0 (gconf);
			return result;
		}
		_tmp0_ = desktop_agnostic_config_schema_new (args[1], &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (schema);
			_g_string_free0 (gconf);
			goto __catch0_g_error;
		}
		schema = (_tmp1_ = _tmp0_, _g_object_unref0 (schema), _tmp1_);
		gconf = (_tmp2_ = g_string_new ("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"), _g_string_free0 (gconf), _tmp2_);
		g_string_append (gconf, "<gconfschemafile>\n  <schemalist>\n");
		{
			GList* group_collection;
			GList* group_it;
			group_collection = desktop_agnostic_config_schema_get_groups (schema);
			for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
				const char* group;
				group = (const char*) group_it->data;
				{
					char* base_path;
					char* app_name;
					char* path_prefix;
					GValue* _tmp3_;
					char* _tmp5_;
					GValue* _tmp4_;
					char* _tmp6_;
					base_path = NULL;
					app_name = NULL;
					path_prefix = NULL;
					current_group = group;
					_tmp3_ = desktop_agnostic_config_schema_get_metadata_option (schema, "GConf.base_path", &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_free0 (base_path);
						_g_free0 (app_name);
						_g_free0 (path_prefix);
						_g_list_free0 (group_collection);
						_g_object_unref0 (schema);
						_g_string_free0 (gconf);
						goto __catch0_g_error;
					}
					base_path = (_tmp5_ = g_strdup (g_value_get_string (_tmp4_ = _tmp3_)), _g_free0 (base_path), _tmp5_);
					_g_free0 (_tmp4_);
					app_name = (_tmp6_ = g_strdup (desktop_agnostic_config_schema_get_app_name (schema)), _g_free0 (app_name), _tmp6_);
					if (_vala_strcmp0 (group, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT) == 0) {
						char* _tmp7_;
						path_prefix = (_tmp7_ = g_strdup_printf ("%s/%s", base_path, app_name), _g_free0 (path_prefix), _tmp7_);
					} else {
						char* _tmp8_;
						path_prefix = (_tmp8_ = g_strdup_printf ("%s/%s/%s", base_path, app_name, group), _g_free0 (path_prefix), _tmp8_);
					}
					{
						GList* key_collection;
						GList* key_it;
						key_collection = desktop_agnostic_config_schema_get_keys (schema, group);
						for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
							const char* key;
							key = (const char*) key_it->data;
							{
								DesktopAgnosticConfigSchemaOption* option;
								GType type;
								GValue _tmp9_ = {0};
								GValue default_value;
								char* summary;
								char* _tmp10_;
								char* _tmp11_;
								char* _tmp12_;
								char* _tmp14_;
								char* _tmp13_;
								GValue _tmp18_;
								GValue _tmp17_ = {0};
								char* _tmp21_;
								char* _tmp22_;
								gboolean _tmp23_ = FALSE;
								char* _tmp25_;
								option = _g_object_ref0 (desktop_agnostic_config_schema_get_option (schema, group, key));
								type = desktop_agnostic_config_schema_option_get_option_type (option);
								default_value = (g_value_init (&_tmp9_, G_TYPE_STRING), _tmp9_);
								summary = NULL;
								current_key = key;
								g_string_append (gconf, "    <schema>\n");
								g_string_append (gconf, _tmp10_ = g_markup_printf_escaped ("      <key>/schemas%s/%s</key>\n", path_prefix, key));
								_g_free0 (_tmp10_);
								g_string_append (gconf, _tmp11_ = g_markup_printf_escaped ("      <applyto>%s/%s</applyto>\n", path_prefix, key));
								_g_free0 (_tmp11_);
								g_string_append (gconf, _tmp12_ = g_markup_printf_escaped ("      <owner>%s</owner>\n", app_name));
								_g_free0 (_tmp12_);
								g_string_append (gconf, _tmp14_ = g_markup_printf_escaped ("      <type>%s</type>\n", _tmp13_ = schema_type_to_string (type)));
								_g_free0 (_tmp14_);
								_g_free0 (_tmp13_);
								if (type == G_TYPE_VALUE_ARRAY) {
									GType list_type;
									char* _tmp16_;
									char* _tmp15_;
									list_type = desktop_agnostic_config_schema_option_get_list_type (option);
									g_string_append (gconf, _tmp16_ = g_markup_printf_escaped ("      <list_type>%s</list_type>\n", _tmp15_ = schema_type_to_string (list_type)));
									_g_free0 (_tmp16_);
									_g_free0 (_tmp15_);
								}
								g_value_transform ((_tmp18_ = (desktop_agnostic_config_schema_option_get_default_value (option, &_tmp17_), _tmp17_), &_tmp18_), &default_value);
								if (NULL == g_value_get_string (&default_value)) {
									GValue _tmp20_;
									GValue _tmp19_ = {0};
									default_value = (_tmp20_ = (g_value_init (&_tmp19_, G_TYPE_STRING), g_value_set_string (&_tmp19_, ""), _tmp19_), G_IS_VALUE (&default_value) ? (g_value_unset (&default_value), NULL) : NULL, _tmp20_);
								}
								g_string_append (gconf, _tmp21_ = g_markup_printf_escaped ("      <default>%s</default>\n", g_value_get_string (&default_value)));
								_g_free0 (_tmp21_);
								g_string_append (gconf, "      <locale name=\"C\">\n");
								summary = (_tmp22_ = g_strdup (desktop_agnostic_config_schema_option_get_summary (option)), _g_free0 (summary), _tmp22_);
								if (summary != NULL) {
									_tmp23_ = _vala_strcmp0 (summary, "") != 0;
								} else {
									_tmp23_ = FALSE;
								}
								if (_tmp23_) {
									char* _tmp24_;
									g_string_append (gconf, _tmp24_ = g_markup_printf_escaped ("        <short>%s</short>\n", summary));
									_g_free0 (_tmp24_);
								}
								g_string_append (gconf, _tmp25_ = g_markup_printf_escaped ("        <long>%s</long>\n", desktop_agnostic_config_schema_option_get_description (option)));
								_g_free0 (_tmp25_);
								g_string_append (gconf, "      </locale>\n");
								g_string_append (gconf, "    </schema>\n");
								_g_object_unref0 (option);
								G_IS_VALUE (&default_value) ? (g_value_unset (&default_value), NULL) : NULL;
								_g_free0 (summary);
							}
						}
					}
					_g_free0 (base_path);
					_g_free0 (app_name);
					_g_free0 (path_prefix);
				}
			}
			_g_list_free0 (group_collection);
		}
		g_string_append (gconf, "  </schemalist>\n</gconfschemafile>\n");
		if (args_length1 < 3) {
			fprintf (stdout, "%s", gconf->str);
		} else {
			g_file_set_contents (args[2], gconf->str, gconf->len, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (schema);
				_g_string_free0 (gconf);
				goto __catch0_g_error;
			}
		}
		_g_object_unref0 (schema);
		_g_string_free0 (gconf);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			gboolean _tmp26_ = FALSE;
			if (current_group == NULL) {
				_tmp26_ = TRUE;
			} else {
				_tmp26_ = current_key == NULL;
			}
			if (_tmp26_) {
				g_critical ("lda-schema-to-gconf.vala:194: Error: %s", err->message);
			} else {
				g_critical ("lda-schema-to-gconf.vala:198: Error (%s/%s): %s", current_group, current_key, err->message);
			}
			result = 1;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _main (argv, argc);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




