/***************************************************************************
                           cmanager.h  -  description
                             -------------------
    begin                : Thu Jan 23 2003
    copyright            : (C) 2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CMANAGER_H
#define CMANAGER_H

/**
  *@author Mathias Küster
  *
  * This is dclib's main thread, almost everything runs on this thread.
  * Killing valknut with SIGSEGV to show the backtrace will list
  * all the threads and what they were doing, normally there is
  * just CManager, CAsyncDns and the main thread running the gui,
  * how many hubs or transfers does not matter.
  *
  * Making this class use more than one thread wouldn't be very useful,
  * CManager does not know what it is managing, and having
  * all the hubs running on one thread while all the transfers run on
  * another thread is only slightly better.
  */

#include <dclib/dcos.h>
#include <dclib/core/clist.h>
#include <dclib/core/csingleton.h>
#include <dclib/core/cmutex.h>
#include <dclib/core/cthread.h>

class CManager : public CSingleton<CManager>, public CThread {
public:
	/** */
	CManager();
	/** */
	virtual ~CManager();

	/** */
	void Add( _CCallback0 * callback );
	/** */
	void Remove( _CCallback0 * callback );

	/** */
	virtual void Thread();

private:
	/** */
	CMutex m_CallbacksMutex;
	/** */
	CList<_CCallback0> m_Callbacks;
};

#endif
