/***************************************************************************
                           cfile.cpp  -  description
                             -------------------
    begin                : Wed Apr 3 2003
    copyright            : (C) 2003-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>

#ifndef WIN32
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#endif

#include <dclib/core/cbytearray.h>

#include "cfile.h"

#define FILE_BUFFER_SIZE	(100*1024)

/** */
CFile::CFile()
{
	m_nFD     = -1;
	m_pBuffer = 0;
}

/** */
CFile::~CFile()
{
	Close();

	if ( m_pBuffer )
	{
		delete m_pBuffer;
	}
}

/** */
bool CFile::Open( CString filename, int mode, int acc )
{
	bool res = FALSE;
	int m = 0, a = 0;

	if ( m_nFD != -1 )
	{
		return res;
	}

	m_nMode      = mode;
	m_nBufferPos = 0;

#ifdef WIN32
	if ( (mode & IO_RAW) != 0 )
		m |= _O_BINARY;
	if ( (mode & IO_READONLY) != 0 )
		m |= _O_RDONLY;
	if ( (mode & IO_WRITEONLY) != 0 )
		m |= _O_WRONLY;
	if ( (mode & IO_READWRITE) != 0 )
		m |= _O_RDWR;
	if ( (mode & IO_APPEND) != 0 )
		m |= _O_APPEND;
	if ( (mode & IO_TRUNCATE) != 0 )
		m |= _O_TRUNC;
	if ( (mode & IO_CREAT) != 0 )
		m |= _O_CREAT;
#else
	if ( (mode & IO_RAW) != 0 )
		m |= 0;
	if ( (mode & IO_READONLY) != 0 )
		m |= O_RDONLY;
	if ( (mode & IO_WRITEONLY) != 0 )
		m |= O_WRONLY;
	if ( (mode & IO_READWRITE) != 0 )
		m |= O_RDWR;
	if ( (mode & IO_APPEND) != 0 )
		m |= O_APPEND;
	if ( (mode & IO_TRUNCATE) != 0 )
		m |= O_TRUNC;
	if ( (mode & IO_CREAT) != 0 )
		m |= O_CREAT;
#endif

#ifdef WIN32
	if ( (acc & MO_IRWXU) != 0 )
		a |= _S_IREAD | _S_IWRITE;
	if ( (acc & MO_IRUSR) != 0 )
		a |= _S_IREAD;
	if ( (acc & MO_IWUSR) != 0 )
		a |= _S_IWRITE;
	if ( (acc & MO_IRWXG) != 0 )
		a |= _S_IREAD | _S_IWRITE;
	if ( (acc & MO_IRGRP) != 0 )
		a |= _S_IREAD;
	if ( (acc & MO_IWGRP) != 0 )
		a |= _S_IWRITE;
	if ( (acc & MO_IRWXO) != 0 )
		a |= _S_IREAD | _S_IWRITE;
	if ( (acc & MO_IRGRP) != 0 )
		a |= _S_IREAD;
	if ( (acc & MO_IWOTH) != 0 )
		a |= _S_IWRITE;
#else
	if ( (acc & MO_IRWXU) == MO_IRWXU )
		a |= S_IRWXU;
	if ( (acc & MO_IRUSR) == MO_IRUSR )
		a |= S_IRUSR;
	if ( (acc & MO_IWUSR) == MO_IWUSR )
		a |= S_IWUSR;
	if ( (acc & MO_IXUSR) == MO_IXUSR )
		a |= S_IXUSR;
	if ( (acc & MO_IRWXG) == MO_IRWXG )
		a |= S_IRWXG;
	if ( (acc & MO_IRGRP) == MO_IRGRP )
		a |= S_IRGRP;
	if ( (acc & MO_IWGRP) == MO_IWGRP )
		a |= S_IWGRP;
	if ( (acc & MO_IXGRP) == MO_IXGRP )
		a |= S_IXGRP;
	if ( (acc & MO_IRWXO) == MO_IRWXO )
		a |= S_IRWXO;
	if ( (acc & MO_IRGRP) == MO_IRGRP )
		a |= S_IROTH;
	if ( (acc & MO_IWOTH) == MO_IWOTH )
		a |= S_IWOTH;
	if ( (acc & MO_IXOTH) == MO_IXOTH )
		a |= S_IXOTH;
#endif

#ifdef WIN32
	m_nFD = _open( filename.Data(), m, a );
#else
	m_nFD = open( filename.Data(), m, a );
#endif

	if ( m_nFD != -1 )
	{
		res = TRUE;

		// create write buffer
		if ( (mode & IO_WRITEONLY) != 0 )
		{
			m_pBuffer = new CByteArray(FILE_BUFFER_SIZE);
		}
	}

	return res;
}

/** */
void CFile::Close()
{
	if ( m_nFD != -1 )
	{
		// flush write buffer
		if ( m_nBufferPos != 0 )
		{
			Flush();
		}
#ifdef WIN32
		_close(m_nFD);
#else
		close(m_nFD);
#endif
		m_nFD        = -1;
		m_nBufferPos = 0;

		if ( m_pBuffer )
		{
			delete m_pBuffer;
			m_pBuffer = 0;
		}
	}
}

/** */
long CFile::Flush()
{
	long i = 0;

	if ( (m_nFD != -1) &&
	     ((m_nMode & IO_WRITEONLY) != 0) &&
	     (m_nBufferPos != 0) )
	{
#ifdef WIN32
		i = _write( m_nFD, m_pBuffer->Data(), m_nBufferPos );
#else
		i = write( m_nFD, m_pBuffer->Data(), m_nBufferPos );
#endif
		if ( i == -1 )
		{
			perror("CFile::Flush");
		}
		else if ( i < m_nBufferPos )
		{
			// not all data flushed, fix buffer
			printf("CFile::Flush: write %ld : %d Bytes\n",i,m_nBufferPos);

			if ( i > 0 )
			{
				memcpy(m_pBuffer->Data(),m_pBuffer->Data()+i,m_nBufferPos-i);
				m_nBufferPos -= i;
			}

			i = -1;
		}
		else
		{
			m_nBufferPos = 0;
		}
	}

	return i;
}

/** */
long CFile::Write( const char * buf, long count )
{
	long i = 0;

	if ( (m_nFD == -1) || (count <= 0) || (!buf) )
	{
		return -1;
	}

	if ( (m_nMode & IO_WRITEONLY) != 0 )
	{
		if ( count >= FILE_BUFFER_SIZE )
		{
			i = Flush();
		}
		else if ( (count+m_nBufferPos) > FILE_BUFFER_SIZE )
		{
			i = Flush();

			if ( i != -1 )
			{
				m_nBufferPos = count;
				memcpy(m_pBuffer->Data(),buf,count);

				i = count;
			}
		}
		else
		{
			memcpy(m_pBuffer->Data()+m_nBufferPos,buf,count);
			m_nBufferPos += count;

			i = count;
		}
	}

	// check if flush failed
	if ( i != -1 )
	{
		if ( m_nBufferPos == 0 )
		{
#ifdef WIN32
			i = _write( m_nFD, buf, count );
#else
			i = write( m_nFD, buf, count );
#endif
		}
	}

	return i;
}

/** */
long CFile::Read( char * buf, long count )
{
	long i = -1;

	if ( (m_nFD == -1) || (count <= 0) || (!buf))
	{
		return i;
	}

#ifdef WIN32
	i = _read( m_nFD, buf, count );
#else
	i = read( m_nFD, buf, count );
#endif

	return i;
}

/** */
bool CFile::Seek( ulonglong offset, int origin )
{
	bool res = FALSE;

	if ( m_nFD == -1 )
	{
		return res;
	}

	if ( Flush() == -1 )
	{
		return res;
	}

#ifdef WIN32
	if ( _lseeki64( m_nFD, offset, origin ) == offset )
#else
	if ( lseek( m_nFD, offset, origin ) == offset )
#endif
	{
		res = TRUE;
	}

	return res;
}

/** */
bool CFile::Rename( CString from, CString to )
{
	bool res = FALSE;
	
	if ( (from == "") || (to == "") )
	{
		return res;
	}
	
	if ( rename(from.Data(),to.Data()) == 0 )
	{
		res = TRUE;
	}
	else
	{
		perror("rename");
	}
	
	return res;
}

/** */
bool CFile::Remove( CString s )
{
	bool res = FALSE;
	
	if ( s == "" )
	{
		return res;
	}
	
	if ( remove(s.Data()) == 0 )
	{
		res = TRUE;
	}
	else
	{
		perror("remove");
	}
	
	return res;
}

/** */
ulonglong CFile::GetFileSize( CString s )
{
#ifdef WIN32
	struct _stat buf;
#else
	struct stat buf;
#endif

#ifdef WIN32
	if ( _stat( s.Data(), &buf ) != 0 )
#else
	if ( stat( s.Data(), &buf ) != 0 )
#endif
	{
		return 0;
	}

	return buf.st_size;
}
