/***************************************************************************
                          title.cpp  -  description
                             -------------------
    begin                : Sun Dec 23 2001
    copyright            : (C) 2001 by root
    email                : root@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dbmusic.h"
/* Put here so it's not automatically included by dbinit.h */
#include "dbmusicvalidator.h"
/** Adds the title to the db.
 *
 * Returns error code.
 *@param QString Artist Name
 *@param TitleInfo Pointer to the title information.
 */
int dbMusic::addTitle(const QString &f_artist, const TitleInfo *const t)
{
	// make sure aid is set
	if (f_artist.isEmpty())
		return TITLE_ADD_FAIL;
	// make complete insert, append a formatmap->find(t.fid).data(). validate.
	sqlstring="INSERT INTO title (aid, fid, gid, lid, mid, tid, grpid, yearstart, yearend, nod, notracks, cdlen, notes, name, pic, rating, quality, collected) VALUES (";
	sqlstring.append(artist->find(f_artist).data());
	sqlstring.append(", ");
	sqlstring.append(formatmap->find(t->format).data());
	sqlstring.append(", ");
	sqlstring.append(genremap->find(t->genre).data());
	sqlstring.append(", ");
	sqlstring.append(labelmap->find(t->label).data());
	sqlstring.append(", ");
	sqlstring.append(methodmap->find(t->method).data());
	sqlstring.append(", ");
	sqlstring.append(typemap->find(t->type).data());
	sqlstring.append(", ");
	sqlstring.append(boxset->find(t->boxset).data());
	sqlstring.append(", ");
	sqlstring.append(validateNumQString(t->yearstart));
	sqlstring.append(", ");
	sqlstring.append(validateNumQString(t->yearend));
	sqlstring.append(", ");
	sqlstring.append(validateNumQString(t->nod));
	sqlstring.append(", ");
	sqlstring.append(validateNumQString(t->notracks));
	sqlstring.append(", '");
	sqlstring.append("00:00:00");
	sqlstring.append("', '");
	sqlstring.append(validateQString(t->notes));
	sqlstring.append("', '");
	sqlstring.append(validateQString(t->name));
	sqlstring.append("', '");
	sqlstring.append(validateQString(t->picpath));
	sqlstring.append("', '");
	sqlstring.append(validateNumQString(t->rating));
	sqlstring.append("', '");
	sqlstring.append(validateNumQString(t->quality));
	sqlstring.append("', ");
	if (t->collected)
		sqlstring.append("true");
	else
		sqlstring.append("false");
	sqlstring.append( ")" );
	cerr << "addTitle: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return TITLE_ADD_FAIL;

	return EVERYTHING_OK;
}
/** Deletes title (and subsequent tracks) from the db.
 *
 * Returns error code.
 *@param QString CDID Index Number
 */
int dbMusic::deleteTitle(const QString &cdid)
{
	if (cdid.isEmpty())
		return TITLE_DELETE_FAIL;

	// now delete all the titles. RI takes care of tracks
	sqlstring="DELETE FROM title WHERE cdid=";
	sqlstring.append(validateNumQString(cdid));
	cerr << "deleteTitle: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return TITLE_DELETE_FAIL;
	return EVERYTHING_OK;
}
/** Fills the qmap with category information.
 *@param int Which value to populate (genre, label, etc.)
 *@param QStringList Pointer to the list to be filled.
 */
int dbMusic::getTitle(const QString &cdid, TitleInfo *const z)
{
	if (cdid.isEmpty())
		return TITLE_GET_FAIL;
	sqlstring="SELECT t.name, t.yearstart, t.yearend, t.fid, t.gid, t.lid, t.mid, t.tid, t.grpid, t.nod, t.notracks, t.notes, t.collected, t.cdlen, t.pic, t.rating, t.quality FROM format f, genre g, title t, type ty, label l, method m, boxset grp WHERE f.fid=t.fid and g.gid=t.gid and ty.tid=t.tid and l.lid=t.lid and m.mid=t.mid and grp.grpid=t.grpid and cdid=";
	sqlstring.append(validateNumQString(cdid));
	cerr << "getTitle: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());

	if (execCheck() < 0)
		return TITLE_GET_FAIL;
	if (!Tuples())
		return NO_TUPLES;

	z->cdid=cdid;
	z->name=GetValue(0,0);
	z->yearstart=GetValue(0,1);
	z->yearend=GetValue(0,2);
	z->format=rformatmap->find(GetValue(0,3)).data();
	z->genre=rgenremap->find(GetValue(0,4)).data();
	z->label=rlabelmap->find(GetValue(0,5)).data();
	z->method=rmethodmap->find(GetValue(0,6)).data();
	z->type=rtypemap->find(GetValue(0,7)).data();
	z->boxset=rboxset->find(GetValue(0,8)).data();
	z->nod=GetValue(0,9);
	z->notracks=GetValue(0,10);
	z->notes=GetValue(0,11);
	QString t=GetValue(0,12);
	if (t=="t")
		z->collected=true;
	else
		z->collected=false;
	z->length=GetValue(0,13);
	z->picpath=GetValue(0,14);
	z->rating=GetValue(0,15);
	z->quality=GetValue(0,16);

	return EVERYTHING_OK;
}
/** Updates the title.
 *
 * Returns error code
 *@param TitleInfo Pointer to title information.
 */
int dbMusic::updateTitle(const TitleInfo *const t)
{
	sqlstring="UPDATE title SET fid=";
	sqlstring.append(formatmap->find(t->format).data());
	sqlstring.append(", gid=");
	sqlstring.append(genremap->find(t->genre).data());
	sqlstring.append(", lid=");
	sqlstring.append(labelmap->find(t->label).data());
	sqlstring.append(", mid=");
	sqlstring.append(methodmap->find(t->method).data());
	sqlstring.append(", tid=");
	sqlstring.append(typemap->find(t->type).data());
	sqlstring.append(", grpid=");
	sqlstring.append(boxset->find(t->boxset).data());
	sqlstring.append(", yearstart=");
	sqlstring.append(validateNumQString(t->yearstart));
	sqlstring.append(", yearend=");
	sqlstring.append(validateNumQString(t->yearend));
	sqlstring.append(", nod=");
	sqlstring.append(validateNumQString(t->nod));
	sqlstring.append(", notracks=");
	sqlstring.append(validateNumQString(t->notracks));
	sqlstring.append(", notes='");
	sqlstring.append(validateQString(t->notes));
	sqlstring.append("', pic='");
	sqlstring.append(validateFilename(t->picpath));
	sqlstring.append("', rating='");
	sqlstring.append(validateFilename(t->rating));
	sqlstring.append("', quality='");
	sqlstring.append(validateFilename(t->quality));
	sqlstring.append("', collected=");
	if (t->collected)
		sqlstring.append("true");
	else
		sqlstring.append("false");
	sqlstring.append(", name='");
	sqlstring.append(validateQString(t->name));
	sqlstring.append("' WHERE cdid=");
	sqlstring.append(t->cdid);
	cerr << "updateTitle: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return TITLE_UPDATE_FAIL;

	return EVERYTHING_OK;
}

/** Updates the length of the CD.
 *
 *@param QString CD ID
 */
int dbMusic::updateTime(const QString &cd)
{
	if (cd.isEmpty())
		return TRACK_SUM_FAIL;
	sqlstring="SELECT SUM(length) FROM track WHERE cdid=";
	sqlstring.append(validateNumQString(cd));
	cerr << "sumTrack: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if ((a=execCheck())<0)
		return TITLE_GET_FAIL;
	if(!Tuples())
		return NO_TUPLES;
	QString result=GetValue(0,0);
	if (result=="")
		result="00:00:00";
	sqlstring="UPDATE title SET cdlen='";
	sqlstring.append(result);
	sqlstring.append("' WHERE cdid=");
	sqlstring.append(cd);
	cerr << "updateTitle: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if ((a=execCheck())<0)
		return TITLE_UPDATE_FAIL;

	return EVERYTHING_OK;

}

