/***************************************************************************
                          dbinit.cpp  -  description
                             -------------------
    begin                : Wed Dec 19 2001
    copyright            : (C) 2001 by Will DeRousse
    email                : badhack@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dbinit.h"
/* Put here so it's not automatically included by dbinit.h */
#include "dbmusicvalidator.h"

/**  Constructor
 *@param Standard PostgreSQL connection string (dbname should be template1)
 */
dbInit::dbInit(const QString &dbname) : PgDatabase(dbname.local8Bit().data())
{
	cerr << "Connected to template1" << endl;
}
/**  Destructor
 */
dbInit::~dbInit()
{
}
/** Checks the connection to make sure the db didn't return a bad code. */
bool dbInit::checkConnect()
{
	// if connection is bad, COnnectionBad() returns true, I want to return the opposite.
	return !ConnectionBad();
}
/** This function will create a database (as long as you are connected to template1).
 * @param string Name of database to create.
 */
bool dbInit::createDb( const QString &dbname)
{
	// this is a standard example. build the query using append's to a QString then Exec it to the server
	// and check the return to see if it was good or bad.
	sqlstring = "CREATE DATABASE ";
	sqlstring.append( validateQString(dbname) );
	stat = Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return FALSE;
	return TRUE;
}
/** Returns the errorcode.
 *@param string QString to be set to value of SELECT version()
 */
int dbInit::dbVersion(QString &string)
{
	stat=Exec("SELECT version()");
	if (execCheck()<0)
		return execCheck();
	string=GetValue(0,0);
	return EVERYTHING_OK;
}
/** Use this function to search template1 for a particular database. Returns true if found, false otherwise.
 *@param string dbname to search for
 */
bool dbInit::findDb ( const QString &name)
{
	sqlstring = "SELECT * FROM pg_database where datname = '";
	sqlstring.append(validateQString(name));
	sqlstring.append("'");
	stat = Exec(sqlstring.local8Bit().data());
	int resolve=execCheck();

	if (resolve < 0)
		return FALSE;
	if (!Tuples())
		return FALSE;
	return TRUE;
}
/** This function goes one step farther than checkConnect by sending data to the server first in an attempt to actually communicate with it. I added this function because I think it will add another layer of stability. In other words, some dummy data will get corrupted rather than some important data in the db. */
bool dbInit::testConnect()
{
	stat = Exec("BEGIN");
	if (execCheck())
	{
		stat= Exec("COMMIT");
		return TRUE;
	}
	else
		return FALSE;
}
/** Use this function often to check the status of the server. The return value is the error code. */
int dbInit::execCheck() const
{
	// these are the error code values that can be returned from the server.
	switch(stat)
	{
		case PGRES_EMPTY_QUERY:	return DB_EMPTY_QUERY;
		case PGRES_TUPLES_OK:		return DB_TUPLES_OK;
		case PGRES_COMMAND_OK:	return DB_COMMAND_OK;
		case PGRES_BAD_RESPONSE:return DB_BAD_RESPONSE;
		case PGRES_NONFATAL_ERROR:	return DB_NONFATAL_ERROR;
		case PGRES_FATAL_ERROR:	return DB_FATAL_ERROR;
		default:	return DB_UNKNOWN_ERROR;
	};
}
