/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__SELECT_HPP)
#include <Select.hpp>
#endif

#if   !defined(__EVENTS_HPP)
#include <Events.hpp>
#endif

#if   !defined(__MEMENTOS_HPP)
#include <Mementos.hpp>
#endif

#include <iostream>

using namespace corelinux;
using namespace std;

// Constructor

Select::Select( void )
   :
   SubjectObserver( ),
   theCurrentList()
{
   ;  // do nothing
}

// Copy constructor 

Select::Select( SelectCref ) throw ( Assertion )
   :
   SubjectObserver( ),
   theCurrentList( )
{
   NEVER_GET_HERE;
}

// Destructor

Select::~Select( void )
{
   theCurrentList.clear();
}

// Assignment

SelectRef  Select::operator=( SelectCref ) throw ( Assertion )
{
   NEVER_GET_HERE;
   return ( *this );
}

// Equality

bool Select::operator==( SelectCref aSelect ) const 
{
   return ( this == &aSelect );
}

// The goods

bool  Select::getSelection( void )
{
   bool  keepRunning(false);

   if( theCurrentList.size() != 0 )
   {
      keepRunning = true;
      int   x = 1;
      int   select = 0;

      cout  << endl;

      ListEntriesIterator begin=theCurrentList.begin();

      for( ; begin != theCurrentList.end(); ++begin, ++x )
      {
         cout << x << "\t" << (*begin) << endl;
      }

      --x;

      do
      {
         cout << endl;
         cout << "Enter the number for the entry you want to change, or 0 to quit : ";
         cin >> select;
      } while( select < 0 || select > x );

      if( select != 0  )
      {
         char  crap[2];

         cin.getline( crap, sizeof(crap) );  // peel off the new-line

         ListEvent   aEv(  SelectionMade, new SelectionMemento( theCurrentList[select - 1])  );
         Subject::notifyObservers( (Event<Identifier>*)&aEv );
      }
      else
      {
         keepRunning = false;
      }
      


   }
   return keepRunning;
}

// Called when a event comes my way

void  Select::event( Event<Identifier> *aEvent ) throw ( CORELINUX(NullPointerException) )
{
   //
   // We deal with the selection and get the Select
   //

   ChangedListMementoRef   aChange = 
      dynamic_cast<ChangedListMementoRef>
         (
            dynamic_cast<ListEventPtr>(aEvent)->getMemento()
         );

   theCurrentList = aChange.getList();

}

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:49:01 $
   $Locker:  $
*/


