#if   !defined(__RESTRICTEDACCOUNTPROXY_HPP)
#define __RESTRICTEDACCOUNTPROXY_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__ACCOUNTPROXY_HPP)
#include <AccountProxy.hpp>
#endif

DECLARE_CLASS( RestrictedAccountProxy );

/**
RestrictedAccountProxy is a read/write access proxy with limitations,
you can make deposits but you can't withdraw funds!
*/

class RestrictedAccountProxy : public AccountProxy 
{
public:

   //
   // Constructors and destructor
   //
   
                        /// Default constructor
   
                        RestrictedAccountProxy( void );
   
                        /// Initializing constructor
      
                        RestrictedAccountProxy( AbstractBankAccountPtr );
      
                        /// Copy constructor
      
                        RestrictedAccountProxy( RestrictedAccountProxyCref );
      
                        /// Virtual Destructor
   
   virtual              ~RestrictedAccountProxy( void );
   
   //
   // Operator overloads
   //
   
            /**
            Assignment operator
            @param RestrictedAccountProxy const reference
            @return RestrictedAccountProxy reference
            */
   
            RestrictedAccountProxyRef   operator=( RestrictedAccountProxyCref );
   
            /**
            Equality operator compares the
            subject pointers
            @param RestrictedAccountProxy const reference
            @return bool if subjects match
            */
   
            bool  operator==( RestrictedAccountProxyCref ) const;
   
   //
   // Accessors
   //
            /**
            Retrieve the account balance
            @return Amount const reference to balance
            */
   
            AccountProxy::getBalance;
   
   //
   // Mutators
   //
   
            /**
            Deposit funds into the account
            @param Amount - to deposit
            */
   
            AccountProxy::depositFunds;
   
            /**
            Withdraw funds from the account
            is not allowed and we throw an
            exception
            */

   virtual  void  withdrawFunds( Amount ) 
                     throw( InsufficientFundsException );
      

};

#endif // if   !defined(__RESTRICTEDACCOUNTPROXY_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/02/10 14:32:20 $
   $Locker:  $
*/


