#if !defined (__TRANSPARENTCOMPONENT_HPP)
#define __TRANSPARENTCOMPONENT_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__COMPONENT_HPP)
#include <Component.hpp>
#endif

#if   !defined(__ITERATOR_HPP)
#include <Iterator.hpp>
#endif

#if   !defined(__INVALIDCOMPOSITEEXCEPTION_HPP)
#include <InvalidCompositeException.hpp>
#endif /* __INVALIDCOMPOSITEEXCEPTION_HPP */


namespace corelinux
{
   DECLARE_CLASS(InvalidCompositeException);

   /**
   A TransparentComponent is a templated Component whereas it declares the 
   interface for the objects in a composition, implements default behavior 
   and declares the interface for child operations.
   */

   template<class CompImpl>
      class TransparentComponent : public Component
      {
      public:
   
                              /// Default Constructor
   
                              TransparentComponent( void )
                                 :
                                 Component()
                              {
                                 ;  // do nothing
                              }
   
                              /** Copy Constructor
                              @param TransparentComponent const reference
                              */
   
                              TransparentComponent
                                 ( 
                                    const TransparentComponent & aRef 
                                 )
                                 :
                                 Component( aRef )
                              {
                                 ;  // do nothing
                              }
   
                              /// Virtual Destructor  
   
         virtual              ~TransparentComponent( void )
                              {
                                 ;  // do nothing
                              }
   
         //
         // Operator overloads
         //
                  /**
                  Assignment operator overload
                  @param  TransparentComponent const reference
                  @return TransparentComponent reference to self
                  */
               
                  TransparentComponent & operator=( const TransparentComponent & )
                  {
                     return (*this);
                  }
   
                  /**
                  Equality operator overload
                  @param TransparentComponent const reference
                  @return true if equal, false otherwise
                  */
   
                  bool        operator==
                                 ( 
                                    const TransparentComponent & aRef 
                                 ) const
                  {
                     return (*this = aRef);
                  }
   
                  /**
                  Non-equality operator overload
                  @param TransparentComponent const reference
                  @return false if equal, true otherwise
                  */
   
                  bool        operator!=
                                 ( 
                                    const TransparentComponent & aRef 
                                 ) const
                  {
                     return !(*this = aRef);
                  }

         //
         // Accessors
         //

         //
         // Mutators
         //

                  /**
                  Interface for adding component children to a 
                  composition. The default implementation throws
                  an exception to insure needless calls are not made
                  to leafs components
                  @param CompImpl - Component instantiated with implementation
                  @exception InvalidCompositeInstance 
                  */

         virtual  void  addComponent( CompImpl )  
                           throw(InvalidCompositeException)
                  {
                     throw InvalidCompositeException(LOCATION); 
                  }

                  /**
                  Interface for removing component children from a 
                  composition. The default implementation throws
                  an exception to insure needless calls are not made
                  to leafs
                  @param CompImpl - Component instantiated with implementation
                  @exception InvalidCompositeInstance 
                  */

         virtual  void  removeComponent( CompImpl ) 
                           throw(InvalidCompositeException)
                  {
                     throw InvalidCompositeException(LOCATION); 
                  }

         //
         // Factories
         //

                  /**
                  Interface for creating an Iterator to iterate
                  through the children of a composition.
                  The default implementation throws
                  an exception to insure needless calls are not made
                  to leafs
                  @param CompImpl - Component instantiated with implementation
                  @exception InvalidCompositeInstance 
                  */

         virtual  Iterator<CompImpl>*  createIterator( void )
                                          throw(InvalidCompositeException)
                  {
                     throw InvalidCompositeException(LOCATION); 
                  }

                  /**
                  Interface for returning a created Iterator.
                  It is up to the Composite implementation to
                  provide accounting of Iterator instances that
                  have been given out. The default implementation throws
                  an exception to insure needless calls are not made
                  to leafs
                  @param CompImpl - Component instantiated with implementation
                  @exception InvalidCompositeInstance 
                  */

         virtual  void  destroyIterator( Iterator<CompImpl> * ) 
                           throw(InvalidCompositeException)
                  {
                     throw InvalidCompositeException(LOCATION); 
                  }
   
      };

}
          
#endif   // if !defined(__TRANSPARENTCOMPONENT_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:52:20 $
   $Locker:  $
*/



