/* -*- indent-tabs-mode: t; tab-width: 8; c-basic-offset: 8; -*- */

#ifndef __VOLUME
#define __VOLUME

#include "tree.h"
#include <time.h>

/* Meta-Data pertaining to the volume set */
struct iso_volumeset
{
	int refcount;

	struct iso_tree_dir **root;

	char *volumeset_id;
	int volumeset_size;

	char *publisher_id;
	char *data_preparer_id;

	/* XXX these files must be 8.3, else they break the spec, even for
	   level 2 iso's I think! (so says 8.4.23/4/5) */
	struct iso_tree_file **copyright_file;
	struct iso_tree_file **abstract_file;
	struct iso_tree_file **bibliographic_file;

	/* a value of ((time_t) -1) for these means the time hasn't been
	   specified and no time should be specified in the file system */
	time_t expiration_time;
	time_t effective_time;

	char **volume_id;	/* array of size 'volumeset_size' */

	int system_sectors;
	int header_sectors;
	int *data_sectors;	/* array of size 'volumeset_size' */

	struct iso_volumeset_options
	{
		int iso_level;
		int joliet;
	} options;
};

#endif /* __VOLUME */
