/**
 * ===========================================
 * LibBase : a free Java utility library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libbase
 *
 * (C) Copyright 2007,2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * LibBaseInfo
 * ------------
 * (C) Copyright 2006, by Pentaho Corporation.
 */



package org.pentaho.reporting.libraries.base;

import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;

/**
 * The project information for LibBase.
 *
 * @author Thomas Morgner
 * @noinspection UseOfSystemOutOrSystemErr
 */
public final class LibBaseInfo extends ProjectInformation
{
  private static LibBaseInfo info;

  /**
   * Returns a singleton instance of the LibBase project information structure.
   *
   * @return the LibBase project information.
   */
  public static synchronized ProjectInformation getInstance()
  {
    if (info == null)
    {
      info = new LibBaseInfo();
      info.initialize();
    }
    return info;
  }

  /**
   * Private constructor to prevent object creation.
   */
  private LibBaseInfo()
  {
    super("libbase", "LibBase");
  }

  /**
   * Initializes the project info.
   */
  private void initialize()
  {
    setBootClass(LibBaseBoot.class.getName());
    setLicenseName("LGPL");
    setInfo("http://reporting.pentaho.org/libbase/");
    setCopyright("(C)opyright 2007, by Pentaho Corporation and Contributors");
  }

  /**
   * The main method can be used to check the version of the code.
   *
   * @param args not used.
   */
  public static void main(final String[] args)
  {
    System.out.println(getInstance().getVersion());
  }
}
