------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                         Copyright (C) 2000-2008                          --
--                                 AdaCore                                  --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
------------------------------------------------------------------------------

package body AWS.Dispatchers.Callback is

   -----------
   -- Clone --
   -----------

   overriding function Clone (Dispatcher : in Handler) return Handler is
   begin
      return (AWS.Dispatchers.Handler with Callback => Dispatcher.Callback);
   end Clone;

   ------------
   -- Create --
   ------------

   function Create (Callback : in Response.Callback) return Handler is
   begin
      return (AWS.Dispatchers.Handler with Callback => Callback);
   end Create;

   --------------
   -- Dispatch --
   --------------

   overriding function Dispatch
     (Dispatcher : in Handler;
      Request    : in Status.Data) return Response.Data is
   begin
      return Dispatcher.Callback (Request);
   end Dispatch;

end AWS.Dispatchers.Callback;
