------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                            Copyright (C) 2003                            --
--                                ACT-Europe                                --
--                                                                          --
--  Authors: Dmitriy Anisimkov - Pascal Obry                                --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
--  As a special exception, if other files instantiate generics from this   --
--  unit, or you link this unit with other files to produce an executable,  --
--  this  unit  does not  by itself cause  the resulting executable to be   --
--  covered by the GNU General Public License. This exception does not      --
--  however invalidate any other reasons why the executable file  might be  --
--  covered by the  GNU Public License.                                     --
------------------------------------------------------------------------------

--  $Id: aws-net-ssl-certificate.ads,v 1.1 2003/12/17 14:37:18 obry Exp $

with Ada.Strings.Unbounded;

package AWS.Net.SSL.Certificate is

   use Ada.Strings.Unbounded;

   type Object is private;

   Undefined : constant Object;

   function Get (Socket : in Socket_Type) return Object;
   --  Returns the certificate used by the SSL

   function Subject (Certificate : in Object) return String;
   --  Returns the certificate's subject

   function Issuer  (Certificate : in Object) return String;
   --  Returns the certificate's issuer

private

   type Object is record
      Subject : Unbounded_String;
      Issuer  : Unbounded_String;
   end record;

   Undefined : constant Object
     := (Null_Unbounded_String, Null_Unbounded_String);

end AWS.Net.SSL.Certificate;
