------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                            Copyright (C) 2003                            --
--                                ACT-Europe                                --
--                                                                          --
--  Authors: Dmitriy Anisimkov - Pascal Obry                                --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
--  As a special exception, if other files instantiate generics from this   --
--  unit, or you link this unit with other files to produce an executable,  --
--  this  unit  does not  by itself cause  the resulting executable to be   --
--  covered by the GNU General Public License. This exception does not      --
--  however invalidate any other reasons why the executable file  might be  --
--  covered by the  GNU Public License.                                     --
------------------------------------------------------------------------------

--  $Id: soap-generator-name_set.adb,v 1.1 2003/03/05 18:03:49 obry Exp $

separate (SOAP.Generator)
package body Name_Set is

   Set : array (1 .. 100) of Unbounded_String;
   S   : Natural := 0;

   ---------
   -- Add --
   ---------

   procedure Add (Name : in String) is
   begin
      S := S + 1;
      Set (S) := To_Unbounded_String (Name);
   end Add;

   ------------
   -- Exists --
   ------------

   function Exists (Name : in String) return Boolean is
   begin
      for K in 1 .. S loop
         if To_String (Set (K)) = Name then
            return True;
         end if;
      end loop;

      return False;
   end Exists;

end Name_Set;
