/*-
 * C-SaCzech
 * Copyright (c) 1996-2002 Jaromir Dolecek <dolecek@ics.muni.cz>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Jaromir Dolecek
 *	for the CSacek project.
 * 4. The name of Jaromir Dolecek may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY JAROMIR DOLECEK ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL JAROMIR DOLECEK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: csa_defaults.h,v 1.36 2002/02/03 11:13:41 dolecek Exp $ */

#ifndef _CSA_CONFIG_H_
#define _CSA_CONFIG_H_

/* separator of items in DEFAULT_FILES and others - has to be a char */
#define CSA_SEP	','

/* if document name ends with one of these suffixes, it WILL be converted
 * otherwise the contents won't be touched
 * is used by (Fast)CGI only */
#define CSA_CONVERT_SUFFIXES	".html,.htm,.txt,.cz"

/* list of suffixes to be ignored in SCRIPT_NAME; they won't be ever */
/* a partname */
#define CSA_IGNORE_SUFFIXES	".cgi,.exe,.fcgi,.fgi"

/* add a bar with encoding menu to the end of _every_ page (even if it's
 * not explicitly requested by BAR command) ? */
/* #undef CSA_ALWAYSADDBAR */

/* use long names in the BAR ? */
/* #undef CSA_LONGNAMEBAR */

/* czech text written before bar itself */ 
#define CSA_HEADBARTEXT          "<HR><EM><A HREF=\"http://www.csacek.cz/\">C-SaCzech</A></EM> - <B>volba k&oacute;dov&aacute;n&iacute;:</B> <BR>"

/* english text written before bar itself */
#define CSA_EHEADBARTEXT          "<HR><EM><A HREF=\"http://www.csacek.cz/\">C-SaCzech</A></EM> - <B>select encoding of czech characters:</B> <BR>"

/* czech text written after bar itself */
#define CSA_TAILBARTEXT          "<HR>"

/* english text written after bar itself */
#define CSA_ETAILBARTEXT          "<HR>"

/* add the link to ``whichcode'' script to the bar by default too */
/* #undef CSA_ADDWHICHCODE */

/* default name of link to ``whichcode'' script */
#define CSA_BARWHICHCODENAME          "whichcode"

/* redirect client to URL ending with '/' if it doesn't and points
 * to a directory; you should leave this defined */
#define CSA_CANONIFY_DIRURL

/* be compatible with CSacek 1.3.X and previous */
#define CSA_COMPAT_13X

/* basic support for Mr. Lampa's Apache module -- __LAMPANAME__ is
 * substituted by output charset name in form used by that module */
#define CSA_COMPAT_LAMPA

/* default partname; used when there is no explicit partname set, such as
 * when SCRIPT_NAME is something like "/cgi-bin/toASCII" */
#define CSA_DEFAULT_PARTNAME	"cs"

/* default IgnorePrefix (see Apache configuration command csacekIgnorePrefix)
 * important for Apache module only */
#define CSA_DEFAULT_IGNOREPREFIX	"/cgi-bin"

/* directory with template files, used for example by CSacek's whichcode */
#define CSA_WHICHCODETEMPLATE	"whichcode_template.html"

/* if a requested document ends with one of these suffixes, CSacek will
 * ignore it and won't touch it at all */
#define CSA_NONCSACEK	".gif,.jpg,.ps,.gz,.tgz,.zip,.mov"

#endif /* _CSA_CONFIG_H_ */
