--  example program for the use of package X_Auth (part of Adabindx)
--
with Ada.Text_Io,
     Interfaces.C,
     X_Connection,
     X_Auth;
procedure Xau_Test is

   package Int_Io is new Ada.Text_Io.Integer_Io (Integer);

   type String_Access is access all String;

   Auth_File_Name : String_Access;


   procedure Put_Adr (Data   : in X_Connection.Net_Address;
                      Spacer : in String) is
   begin
      if Data'Length > 1 then
         Int_Io.Put (Integer (Data (Data'First)), Width => 1);
         for J in Natural'Succ (Data'First) .. Data'Last loop
            Ada.Text_Io.Put (Spacer);
            Int_Io.Put (Integer (Data (J)), Width => 1);
         end loop;
         Ada.Text_Io.New_Line;
      else
         Int_Io.Put (Integer (Data (Data'First)), Width => 1);
	 Ada.Text_Io.New_Line;
      end if;
   end Put_Adr;


   procedure Put_Bytes (Data   : in X_Auth.Byte_Data;
                        Spacer : in String) is
      procedure Put (Data : in Interfaces.C.Unsigned_Char) is
         use Interfaces.C;
         Number : Interfaces.C.Unsigned_Char := Data;
         Table : array (Interfaces.C.Unsigned_Char range 0 .. 15) of Character
	       :=('0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
	          'A', 'B', 'C', 'D', 'E', 'F');
      begin
         Ada.Text_Io.Put (Table (Number/16) & Table (Number mod 16));
      end Put;
   begin
      if Data'Length > 1 then
         Put (Data (Data'First));
         for J in Natural'Succ (Data'First) .. Data'Last loop
            Ada.Text_Io.Put (Spacer);
            Put (Data (J));
         end loop;
         Ada.Text_Io.New_Line;
      else
         Put (Data (Data'First));
	 Ada.Text_Io.New_Line;
      end if;
   end Put_Bytes;

begin
   Auth_File_Name := new String'(X_Auth.Xau_File_Name);

   Ada.Text_Io.Put_Line ("...reading authorization information from file """ &
                         Auth_File_Name.all & """");
   Ada.Text_Io.New_Line;

   declare
      List : constant X_Auth.Xauth_List
           := X_Auth.Xau_Read_Auth (Auth_File_Name.all);
   begin
      for I in List'Range loop
         Ada.Text_Io.Put_Line ("Entry " & Integer'Image (I) & ":");
         Ada.Text_Io.Put ("   Family: ");
	 case List (I).Family is
	    when X_Connection.Family_Internet =>
	       Ada.Text_Io.Put_Line ("Internet");
               Ada.Text_Io.Put ("   Address: ");
	       Put_Adr (List (I).Address, ".");
            when X_Connection.Family_DEC_Net =>
	       Ada.Text_Io.Put_Line ("DEC-Net");
               Ada.Text_Io.Put ("   Address: ");
	       Put_Adr (List (I).Address, ":");
            when X_Connection.Family_Chaos =>
	       Ada.Text_Io.Put_Line ("Chaos-Net");
               Ada.Text_Io.Put ("   Address: ");
	       Put_Adr (List (I).Address, " ");
            when X_Auth.Family_Local =>
	       Ada.Text_Io.Put_Line ("Local-Connection");
               Ada.Text_Io.Put ("   Address: ");
	       Put_Adr (List (I).Address, " ");
            when others =>
	       Ada.Text_Io.Put_Line ("other connection (" &
	          Integer'Image (Integer (List (I).Family)) & ")");
               Ada.Text_Io.Put ("   Address: ");
	       Put_Adr (List (I).Address, " ");
         end case;
         Ada.Text_Io.Put_Line ("   Display number: """ &
	                       List (I).Display_Number & """");
         Ada.Text_Io.Put_Line ("   Authorization name: """ &
	                       List (I).Auth_Name & """");
         Ada.Text_Io.Put ("   Authorization data: ");
	 Put_Bytes (List (I).Auth_Data, " ");
      end loop;
   end;
end Xau_Test;
