-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2000 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--          Nov 14, 1998 HFVogt: X_List_Extensions is in X_Lib.Extensions now!
--
-------------------------------------------------------------------------------

with X_Toolkit,
     X_Lib.Extensions,
     X_Lib.Tasking,
     Ada.Text_Io,
     String_List;
use  X_Toolkit,
     X_Lib,
     Ada.Text_Io,
     String_List;
procedure Show_Extensions is

   Appshell : Widget;
   Display  : Display_Pointer;
   App_Con  : Xt_App_Context;

   Exts : Element_Access_List;

begin
   X_Lib.Tasking.Resource.Seize;

   Xt_App_Initialize (Appshell, App_Con, "ShowHosts");
   Display := Xt_Display (Appshell);

   Exts := Extensions.X_List_Extensions (Display);
   for I in 1 .. Length (Exts) loop
      Ada.Text_Io.Put_Line (Element (Exts, I));
   end loop;

end Show_Extensions;
