-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2002 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--          03 Feb 2002 H.-F. Vogt: replace Xm_Message_Box_Get_Child
--                                  by Xt_Name_To_Widget
--
-------------------------------------------------------------------------------

with X_Lib,
     X_Toolkit,
     Xm_Widgets.Manager.Bulletin_Board.Message_Box,
     Earth;
package body Hello_World_Global is

   use X_Toolkit,
       Xm_Widgets.Manager.Bulletin_Board.Message_Box;


   procedure Show_Dialog_CB
     (W                 : in X_Toolkit.Widget;
      Closure           : in X_Toolkit.Xt_Pointer;
      Call_Data         : in X_Toolkit.Xt_Pointer) is
      Str   : Xm_Widgets.Xm_String;
      Pix   : X_Lib.Pixmap_ID;
   begin
      -- if the dialog hasn't already been created, create it NOW
      if the_dialog = Null_Widget then
	 the_dialog := Xm_Create_Information_Dialog (Appshell, "the_dialog");
         -- create the message string
	 Str := Xm_Widgets.Xm_String_Create_L_To_R ("Hello You!" & ASCII.LF & ASCII.LF &
				       "(X11 and Motif in Ada" & ASCII.LF &
				       " is GREAT!!)");
         Argl := Null_Arg_List;
	 Xm_Widgets.Append_Set (Argl, Xm_N_Message_String, Str);

         -- create the pixmap which will be shown to the left side of the
	 -- message string (the second parameter uses the Appshell, not the
	 -- newly created dialog as the drawable, because the dialog isn't
	 -- realized until now and so hasn't got a window)
         Pix := X_Lib.X_Create_Pixmap_From_Bitmap_Data (Xt_Display (the_dialog),
	    Xt_Window (Appshell), Earth.Earth_Bitmap,
	    X_Lib.X_Black_Pixel_Of_Screen (Xt_Screen (the_dialog)),
	    X_Lib.X_White_Pixel_Of_Screen (Xt_Screen (the_dialog)),
	    X_Lib.X_Default_Depth_Of_Screen (Xt_Screen (the_dialog)));
         Append_Set (Argl, Xm_N_Symbol_Pixmap, X_Lib.XID (Pix));

	 Xt_Set_Values (the_dialog, Argl);
	 Xm_Widgets.Xm_String_Free (Str);

         -- we only need the "OK"-Button, so unmanage unneeded buttons
         Xt_Unmanage_Child (Xt_Name_To_Widget (the_dialog, Cancel_Button_Name));
         Xt_Unmanage_Child (Xt_Name_To_Widget (the_dialog, Help_Button_Name));

      end if;
      -- if not already managed, manage the dialog now. This causes the dialog
      -- to be mapped (to be visible on the screen)
      if not Xt_Is_Managed (the_dialog) then
	 Xt_Manage_Child (the_dialog);
      end if;
   end Show_Dialog_CB;

end Hello_World_Global;
