/* $Id: msg.cpp,v 1.3 2001/07/10 03:22:57 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of a library used by the Archimedes email client     * 
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2001 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU Library General Public License as published *
 *   by the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU Library General Public License for more details.                      *
 *                                                                             *
 *   You should have received a copy of the GNU Library General Public License *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 ******************************************************************************/


#include <config.h>
#include <fmail.h>

struct _mime_msg *get_view_part(struct _mail_msg *msg) {
	struct _mime_msg *mime, *preamble = NULL, *epilog = NULL;

	if((mime = get_text_part(msg)) != NULL)
		return mime;

	mime = msg->mime;
	while(mime) {
		if(mime->flags & PREAMBLE)
			preamble = mime;
		else if(mime->flags & EPILOG)
			epilog = mime;
		else if(!strcasecmp(mime->mailcap->type_text, "text"))
			break;
		mime = mime->mime_next;
	}

	if(mime)
		return mime;

	return preamble ? preamble : epilog;
}
