dnl Checks for the --with-dbm-lib option on ./configure, if given it appends the 
dnl LIBS var accordingly.

AC_DEFUN([DBM_LIB], [

AC_ARG_WITH(dbm-lib,
  [  --with-dbm-lib=lib      DBM library to use],[
    if test x$withval = xyes; then
        AC_MSG_WARN(Usage is: --with-dbm-lib=lib)
    else
         if test x$withval = xno; then
	          AC_MSG_WARN(Usage is: --with-dbm-lib=lib)
         else
	          AC_CHECK_LIB($withval, dbm_open, LIBS="-l$withval $LIBS", CV_LIB_ERROR(dbm_open, $withval))
         fi
     fi]
,
	[AC_CHECK_FUNCS(dbm_open,[],
		[AC_CHECK_LIB(dbm, dbm_open, LIBS="-ldbm $LIBS",
			[AC_CHECK_LIB(db, dbm_open, LIBS="-ldb $LIBS",
				[AC_CHECK_LIB(gdbm, dbm_open, LIBS="-lgdbm $LIBS",
					CV_LIB_ERROR(dbm_open,GNU or Berkeley dbm))])])])
])])


dnl Checks for the dbm header on the system
AC_DEFUN([DBM_HDR], [

AC_CHECK_HEADER(ndbm.h,[
        AC_DEFINE(USE_NDBM)
        prog_cv_dbm=ndbm
],[AC_CHECK_HEADER(db1/ndbm.h,[
        AC_DEFINE(USE_DB1_NDBM)
        prog_cv_dbm=ndbm
],[AC_CHECK_HEADER(gdbm-ndbm.h,[
        AC_DEFINE(USE_GDBM_NDBM)
        prog_cv_dbm=gdbm
],[AC_CHECK_HEADER(gdbm.h,[
        AC_DEFINE(USE_GDBM)
        prog_cv_dbm=gdbm
],CV_LIB_ERROR(ndbm.h,GNU or Berkeley dbm))])])])
])


dnl Checks to see what dbm_open() expects 
AC_DEFUN([DBM_OPN], [
AC_CACHE_CHECK(type of mode dbm_open expects, prog_cv_dbmopen_type, [
if test "x$prog_cv_dbm" = "xgdbm"; then
	AC_TRY_COMPILE([#include <gdbm/ndbm.h>], [extern DBM * dbm_open (const char *f, int flags, mode_t mode);], prog_cv_dbmopen_type=mode_t, prog_cv_dbmopen_type=int)
else
	if test "x$prog_cv_dbm" = "xndbm"; then
		AC_TRY_COMPILE([#include <ndbm.h>], [extern DBM * dbm_open (const char *f, int flags, mode_t mode);], prog_cv_dbmopen_type=mode_t, prog_cv_dbmopen_type=int)
	else
		CV_ERROR(Must have some kind of DBM.)
	fi
fi])

if test "x$prog_cv_dbmopen_type" = "xmode_t"; then
  AC_DEFINE(DBMOPEN_MODE_T, 1, [Define if your dbm_open takes a type mode_t as the third argument.])
fi
])
